/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RatQuarryBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] STACKS = IntStream.range(0, 64).toArray();
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)64, (Object)ItemStack.f_41583_);
    private int tick;

    public RatQuarryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_QUARRY.get(), pos, state);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.inventory, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventory, (int)index);
    }

    public int[] m_7071_(Direction direction) {
        return STACKS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        if (player.m_9236_().m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatQuarryBlockEntity te) {
        if (!level.m_5776_()) {
            BlockPos nextStairPos;
            ++te.tick;
            if (te.tick % 20 == 0 && (level.m_46859_(nextStairPos = te.getNextPosForStairs(level)) || level.m_8055_(nextStairPos).m_247087_())) {
                level.m_46597_(nextStairPos, ((Block)RatsBlockRegistry.RAT_QUARRY_PLATFORM.get()).m_49966_());
                level.m_247517_(null, nextStairPos, SoundEvents.f_12019_, SoundSource.BLOCKS);
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.inventory);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.rats.rat_quarry");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new ChestMenu(MenuType.f_39962_, id, player, (Container)this, 6);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ChestMenu(MenuType.f_39962_, id, playerInventory, (Container)this, 6);
    }

    public boolean m_8077_() {
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.handleUpdateTag(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public int getRadius() {
        return 2;
    }

    public BlockPos getNextPosForStairs(Level level) {
        BlockPos stairPos = this.m_58899_().m_7918_(-this.getRadius(), -1, -this.getRadius());
        int passedLevels = 0;
        for (int yLevel = this.m_58899_().m_123342_() - 1; yLevel > this.m_58904_().m_141937_() + 1; --yLevel) {
            if (yLevel == this.m_58899_().m_123342_() - 1) {
                int i;
                BlockPos checkingPos = this.m_58899_().m_7495_();
                for (i = 0; i < this.getRadius(); ++i) {
                    if (level.m_46859_(checkingPos)) {
                        return checkingPos;
                    }
                    checkingPos = checkingPos.m_121945_(Direction.NORTH);
                }
                for (i = 0; i <= this.getRadius(); ++i) {
                    if (level.m_46859_(checkingPos)) {
                        return checkingPos;
                    }
                    checkingPos = checkingPos.m_121945_(Direction.WEST);
                }
            }
            boolean atLevel = false;
            for (BlockPos pos : BlockPos.m_121990_((BlockPos)new BlockPos(this.m_58899_().m_123341_() - this.getRadius(), yLevel, this.m_58899_().m_123343_() - this.getRadius()), (BlockPos)new BlockPos(this.m_58899_().m_123341_() + this.getRadius(), yLevel, this.m_58899_().m_123343_() + this.getRadius())).map(BlockPos::m_7949_).toList()) {
                if (!level.m_8055_(pos).m_60713_((Block)RatsBlockRegistry.RAT_QUARRY_PLATFORM.get()) && !level.m_8055_(pos).m_204336_(RatsBlockTags.QUARRY_IGNORABLES)) continue;
                atLevel = true;
                break;
            }
            if (!atLevel) break;
            ++passedLevels;
        }
        stairPos = stairPos.m_6625_(passedLevels);
        Direction buildDir = Direction.SOUTH;
        for (int i = 0; i < passedLevels; ++i) {
            if (i > 0 && i % (this.getRadius() * 2) == 0) {
                buildDir = buildDir.m_122428_();
            }
            stairPos = stairPos.m_121945_(buildDir);
        }
        return stairPos;
    }
}

