/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.RatCageBlock;
import com.github.alexthe666.rats.server.block.RatCageWheelBlock;
import com.github.alexthe666.rats.server.block.entity.DecoratedRatCageBlockEntity;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatsEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class RatCageWheelBlockEntity
extends DecoratedRatCageBlockEntity {
    public int useTicks = 0;
    public float wheelRot;
    public float prevWheelRot;
    private final RandomSource random = RandomSource.m_216327_();
    private TamedRat wheeler;
    private float goalOfWheel = 0.0f;
    private int dismountCooldown = 0;
    public final LazyOptional<RatsEnergyStorage> energyStorage = RatsEnergyStorage.create(1000, 10, 10, 0);

    public RatCageWheelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_CAGE_WHEEL.get(), pos, state);
    }

    @Override
    public ItemStack getContainedItem() {
        return new ItemStack((ItemLike)RatsItemRegistry.RAT_WHEEL.get());
    }

    @Override
    public void setContainedItem(ItemStack stack) {
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("UseTicks", this.useTicks);
        if (this.energyStorage.resolve().isPresent()) {
            compound.m_128405_("StoredEnergy", ((RatsEnergyStorage)this.energyStorage.resolve().get()).energy);
        }
        compound.m_128405_("DismountCooldown", this.dismountCooldown);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.useTicks = compound.m_128451_("UseTicks");
        this.dismountCooldown = compound.m_128451_("DismountCooldown");
        if (this.energyStorage.resolve().isPresent()) {
            ((RatsEnergyStorage)this.energyStorage.resolve().get()).energy = compound.m_128451_("StoredEnergy");
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatCageWheelBlockEntity te) {
        te.prevWheelRot = te.wheelRot;
        float wheelAdd = 20.0f;
        if (te.dismountCooldown > 0) {
            --te.dismountCooldown;
        }
        if (te.wheeler == null && te.dismountCooldown <= 0) {
            for (TamedRat rat : level.m_45976_(TamedRat.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0))) {
                if (!rat.m_21824_()) continue;
                te.wheeler = rat;
            }
        }
        if (te.wheeler != null) {
            double dist = te.wheeler.m_20275_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
            BlockState ratWheelState = level.m_8055_(te.wheeler.m_20183_());
            Direction facing = Direction.NORTH;
            if (state.m_60713_((Block)RatsBlockRegistry.RAT_CAGE_WHEEL.get())) {
                facing = (Direction)state.m_61143_((Property)RatCageWheelBlock.FACING);
            }
            te.wheeler.m_146922_(facing.m_122435_());
            te.wheeler.f_20883_ = te.wheeler.m_146908_();
            if (te.useTicks <= 20 || !(dist > 3.0) && ratWheelState == state) {
                if (te.wheeler != null) {
                    te.wheeler.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.15f, (float)pos.m_123343_() + 0.5f);
                    te.wheeler.setInWheel(true);
                    ++te.useTicks;
                    if (te.energyStorage.resolve().isPresent()) {
                        RatsEnergyStorage storage = (RatsEnergyStorage)te.energyStorage.resolve().get();
                        int nrg = 10;
                        if (RatUpgradeUtils.hasUpgrade(te.wheeler, (Item)RatsItemRegistry.RAT_UPGRADE_SPEED.get())) {
                            wheelAdd = 40.0f;
                            nrg = 20;
                        }
                        if (storage.receiveEnergy(nrg, true) != 0) {
                            storage.receiveEnergy(nrg, false);
                        }
                        te.wheelRot += wheelAdd;
                        RatCageBlock cageBlock = (RatCageBlock)state.m_60734_();
                        if (te.useTicks > 200 && te.useTicks % 100 == 0 && te.random.m_188501_() > 0.25f) {
                            for (Direction direction : Direction.values()) {
                                if (cageBlock.runConnectionLogic(level.m_8055_(pos.m_121945_(direction))) != 1 || te.wheeler == null) continue;
                                te.wheeler.m_6034_((float)pos.m_121945_(direction).m_123341_() + 0.5f, (float)pos.m_121945_(direction).m_123342_() + 0.5f, (float)pos.m_121945_(direction).m_123343_() + 0.5f);
                                te.wheeler.setInWheel(false);
                                te.wheeler = null;
                                te.dismountCooldown = 1200 + te.random.m_188503_(1200);
                            }
                        }
                    }
                }
            } else {
                te.wheeler.setInWheel(false);
                te.wheeler = null;
            }
        } else {
            if (te.useTicks != 0) {
                te.wheelRot %= 360.0f;
                te.goalOfWheel = (float)Mth.m_14143_((float)((te.wheelRot + 90.0f) / 90.0f)) * 90.0f % 360.0f;
                te.prevWheelRot = te.wheelRot % 360.0f;
            }
            te.useTicks = 0;
            if (Math.toRadians(te.wheelRot) % 90.0 != 0.0 && !(Math.abs(te.goalOfWheel - te.wheelRot) < 1.5f)) {
                if (te.wheelRot > te.goalOfWheel) {
                    te.wheelRot -= Math.min(wheelAdd, te.wheelRot - te.goalOfWheel);
                } else if (te.wheelRot < te.goalOfWheel) {
                    te.wheelRot += Math.min(wheelAdd, te.goalOfWheel - te.wheelRot);
                }
            } else {
                te.goalOfWheel = 0.0f;
                te.prevWheelRot = 0.0f;
                te.wheelRot = 0.0f;
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ENERGY ? this.energyStorage.cast() : super.getCapability(capability, facing);
    }
}

