/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry;

import com.github.alexthe666.rats.registry.RatsCauldronRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.AutoCurdlerBlock;
import com.github.alexthe666.rats.server.block.CheeseCauldronBlock;
import com.github.alexthe666.rats.server.block.CursedGarbageBlock;
import com.github.alexthe666.rats.server.block.DyeSpongeBlock;
import com.github.alexthe666.rats.server.block.GarbageBlock;
import com.github.alexthe666.rats.server.block.MilkCauldronBlock;
import com.github.alexthe666.rats.server.block.PiedGarbageBlock;
import com.github.alexthe666.rats.server.block.PurifiedGarbageBlock;
import com.github.alexthe666.rats.server.block.RatAttractorBlock;
import com.github.alexthe666.rats.server.block.RatCageBlock;
import com.github.alexthe666.rats.server.block.RatCageBreedingLanternBlock;
import com.github.alexthe666.rats.server.block.RatCageDecoratedBlock;
import com.github.alexthe666.rats.server.block.RatCageWheelBlock;
import com.github.alexthe666.rats.server.block.RatCraftingTableBlock;
import com.github.alexthe666.rats.server.block.RatHoleBlock;
import com.github.alexthe666.rats.server.block.RatQuarryBlock;
import com.github.alexthe666.rats.server.block.RatQuarryPlatformBlock;
import com.github.alexthe666.rats.server.block.RatTrapBlock;
import com.github.alexthe666.rats.server.block.RatTubeBlock;
import com.github.alexthe666.rats.server.block.RatUpgradeBlock;
import com.github.alexthe666.rats.server.block.SetupHorizontalBlock;
import com.github.alexthe666.rats.server.block.TrashCanBlock;
import com.github.alexthe666.rats.server.block.UpgradeCombinerBlock;
import com.github.alexthe666.rats.server.block.UpgradeSeparatorBlock;
import com.github.alexthe666.rats.server.items.RatsBlockItem;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RatsBlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"rats");
    public static final RegistryObject<Block> BLOCK_OF_CHEESE = RatsBlockRegistry.register("block_of_cheese", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60918_(SoundType.f_56750_).m_60913_(0.6f, 0.0f)));
    public static final RegistryObject<Block> MILK_CAULDRON = RatsBlockRegistry.register("cauldron_milk", () -> new MilkCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_)));
    public static final RegistryObject<Block> CHEESE_CAULDRON = RatsBlockRegistry.register("cauldron_cheese", () -> new CheeseCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), BLOCK_OF_CHEESE, RatsCauldronRegistry.CHEESE));
    public static final RegistryObject<Block> BLUE_CHEESE_CAULDRON = RatsBlockRegistry.register("cauldron_blue_cheese", () -> new CheeseCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), BLOCK_OF_BLUE_CHEESE, RatsCauldronRegistry.BLUE_CHEESE));
    public static final RegistryObject<Block> NETHER_CHEESE_CAULDRON = RatsBlockRegistry.register("cauldron_nether_cheese", () -> new CheeseCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), BLOCK_OF_NETHER_CHEESE, RatsCauldronRegistry.NETHER_CHEESE));
    public static final RegistryObject<Block> RAT_HOLE = BLOCKS.register("rat_hole", () -> new RatHoleBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60955_().m_60988_().m_60913_(1.3f, 0.0f)));
    public static final RegistryObject<Block> RAT_CAGE = RatsBlockRegistry.register("rat_cage", () -> new RatCageBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60955_().m_60913_(2.0f, 0.0f)));
    public static final RegistryObject<Block> RAT_CAGE_DECORATED = BLOCKS.register("rat_cage_decorated", () -> new RatCageDecoratedBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)RAT_CAGE.get()))));
    public static final RegistryObject<Block> RAT_CAGE_BREEDING_LANTERN = BLOCKS.register("rat_cage_breeding_lantern", () -> new RatCageBreedingLanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)RAT_CAGE.get()))));
    public static final RegistryObject<Block> RAT_CAGE_WHEEL = BLOCKS.register("rat_cage_wheel", () -> new RatCageWheelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)RAT_CAGE.get()))));
    public static final RegistryObject<Block> FISH_BARREL = RatsBlockRegistry.register("fish_barrel", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> RAT_CRAFTING_TABLE = RatsBlockRegistry.register("rat_crafting_table", () -> new RatCraftingTableBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56750_).m_60913_(2.0f, 0.0f)));
    public static final RegistryObject<Block> AUTO_CURDLER = RatsBlockRegistry.register("auto_curdler", () -> new AutoCurdlerBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60999_().m_60955_().m_60913_(2.0f, 0.0f)));
    public static final RegistryObject<Block> RAT_TRAP = RatsBlockRegistry.register("rat_trap", () -> new RatTrapBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60910_().m_60913_(1.0f, 0.0f)));
    public static final RegistryObject<Block> RAT_TUBE_COLOR = BLOCKS.register("rat_tube", () -> new RatTubeBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60913_(0.9f, 0.0f)));
    public static final RegistryObject<Block> RAT_UPGRADE_BLOCK = RatsBlockRegistry.register("rat_upgrade_block", () -> new RatUpgradeBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56750_).m_60913_(0.6f, 0.0f)));
    public static final RegistryObject<Block> DYE_SPONGE = RatsBlockRegistry.register("dye_sponge", () -> new DyeSpongeBlock(BlockBehaviour.Properties.m_284310_().m_60913_(0.6f, 0.0f).m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<Block> GARBAGE_PILE = RatsBlockRegistry.register("garbage_pile", () -> new GarbageBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56739_).m_60913_(0.7f, 1.0f).m_60977_(), 1.0));
    public static final RegistryObject<Block> CURSED_GARBAGE = RatsBlockRegistry.register("cursed_garbage", () -> new CursedGarbageBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GARBAGE_PILE.get()))));
    public static final RegistryObject<Block> COMPRESSED_GARBAGE = RatsBlockRegistry.register("compressed_garbage", () -> new GarbageBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GARBAGE_PILE.get())), 2.0));
    public static final RegistryObject<Block> PURIFIED_GARBAGE = RatsBlockRegistry.register("purified_garbage", () -> new PurifiedGarbageBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GARBAGE_PILE.get()))));
    public static final RegistryObject<Block> PIED_GARBAGE = RatsBlockRegistry.register("pied_garbage", () -> new PiedGarbageBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GARBAGE_PILE.get()))));
    public static final RegistryObject<Block> MARBLED_CHEESE_RAW = RatsBlockRegistry.register("marbled_cheese_raw", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> JACK_O_RATERN = RatsBlockRegistry.register("jack_o_ratern", () -> new SetupHorizontalBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60913_(1.0f, 0.0f).m_60953_(value -> 15)));
    public static final RegistryObject<Block> BLOCK_OF_BLUE_CHEESE = RatsBlockRegistry.register("block_of_blue_cheese", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(0.6f, 0.0f).m_60918_(SoundType.f_56750_)));
    public static final RegistryObject<Block> BLOCK_OF_NETHER_CHEESE = RatsBlockRegistry.register("block_of_nether_cheese", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(0.6f, 0.0f).m_60918_(SoundType.f_56750_)));
    public static final RegistryObject<Block> PIED_WOOL = RatsBlockRegistry.register("pied_wool", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(1.0f, 0.0f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> UPGRADE_COMBINER = RatsBlockRegistry.register("upgrade_combiner", () -> new UpgradeCombinerBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60999_().m_60955_().m_60913_(5.0f, 0.0f).m_60953_(value -> 4)));
    public static final RegistryObject<Block> UPGRADE_SEPARATOR = RatsBlockRegistry.register("upgrade_separator", () -> new UpgradeSeparatorBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60999_().m_60955_().m_60913_(5.0f, 0.0f).m_60953_(value -> 4)));
    public static final RegistryObject<Block> MANHOLE = RatsBlockRegistry.register("manhole", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283774_).m_60999_().m_60978_(10.0f).m_60918_(SoundType.f_56749_).m_60955_(), BlockSetType.f_271132_));
    public static final RegistryObject<Block> TRASH_CAN = RatsBlockRegistry.register("trash_can", () -> new TrashCanBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60999_().m_60955_().m_60913_(2.0f, 0.0f)));
    public static final RegistryObject<Block> RAT_ATTRACTOR = RatsBlockRegistry.register("rat_attractor", () -> new RatAttractorBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56762_).m_60999_().m_60955_().m_60977_().m_60913_(1.0f, 0.0f)));
    public static final RegistryObject<Block> RAT_QUARRY = RatsBlockRegistry.register("rat_quarry", () -> new RatQuarryBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56750_).m_60913_(2.0f, 0.0f)));
    public static final RegistryObject<Block> RAT_QUARRY_PLATFORM = RatsBlockRegistry.register("rat_quarry_platform", () -> new RatQuarryPlatformBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56750_).m_60955_().m_60913_(1.0f, 0.0f)));

    public static RegistryObject<Block> register(String name, Supplier<Block> blockSupplier) {
        RegistryObject ret = BLOCKS.register(name, blockSupplier);
        RatsItemRegistry.ITEMS.register(name, () -> new RatsBlockItem((Block)ret.get(), new Item.Properties()));
        return ret;
    }
}

