/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.compat.jei;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.compat.jei.ArcheologistRecipeCategory;
import com.github.alexthe666.rats.compat.jei.CauldronInfoHolder;
import com.github.alexthe666.rats.compat.jei.CauldronRecipeCategory;
import com.github.alexthe666.rats.compat.jei.ChefRecipeCategory;
import com.github.alexthe666.rats.compat.jei.RatCraftingTableTransferHandler;
import com.github.alexthe666.rats.compat.jei.RatsRecipeTypes;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsRecipeRegistry;
import java.util.LinkedList;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class RatsJEIPlugin
implements IModPlugin {
    public static final ResourceLocation MOD = new ResourceLocation("rats", "rats");

    private void addDescription(IRecipeRegistration registry, ItemStack itemStack) {
        registry.addIngredientInfo((Object)itemStack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)(itemStack.m_41778_() + ".jei_desc"))});
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        LinkedList<CauldronInfoHolder> cauldrons = new LinkedList<CauldronInfoHolder>();
        cauldrons.add(new CauldronInfoHolder((ItemLike)Items.f_42455_, (ItemLike)Items.f_42455_, (ItemLike)Items.f_42544_, (ItemLike)RatsBlockRegistry.MILK_CAULDRON.get()));
        cauldrons.add(new CauldronInfoHolder((ItemLike)Items.f_41852_, (ItemLike)RatsBlockRegistry.BLOCK_OF_CHEESE.get(), (ItemLike)RatsBlockRegistry.MILK_CAULDRON.get(), (ItemLike)RatsBlockRegistry.CHEESE_CAULDRON.get()));
        cauldrons.add(new CauldronInfoHolder((ItemLike)Items.f_42501_, (ItemLike)RatsBlockRegistry.BLOCK_OF_BLUE_CHEESE.get(), (ItemLike)RatsBlockRegistry.CHEESE_CAULDRON.get(), (ItemLike)RatsBlockRegistry.BLUE_CHEESE_CAULDRON.get()));
        cauldrons.add(new CauldronInfoHolder((ItemLike)Items.f_42448_, (ItemLike)RatsBlockRegistry.BLOCK_OF_NETHER_CHEESE.get(), (ItemLike)RatsBlockRegistry.CHEESE_CAULDRON.get(), (ItemLike)RatsBlockRegistry.NETHER_CHEESE_CAULDRON.get()));
        runtime.getRecipeManager().addRecipes(RatsRecipeTypes.CAULDRON, cauldrons);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registry.addRecipes(RatsRecipeTypes.CHEF, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RatsRecipeRegistry.CHEF.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.CHEESE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.CHEESE_STICK.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.RAT_FLUTE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_BASIC.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_CHEF.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_WHITELIST.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsBlockRegistry.RAT_TRAP.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsBlockRegistry.RAT_CAGE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)RatsBlockRegistry.RAT_CRAFTING_TABLE.get()));
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED) {
            registry.addRecipes(RatsRecipeTypes.ARCHEOLOGIST, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RatsRecipeRegistry.ARCHEOLOGIST.get()));
            this.addDescription(registry, new ItemStack((ItemLike)RatlantisItemRegistry.RAT_UPGRADE_ARCHEOLOGIST.get()));
        } else if (!RatsMod.RATLANTIS_ITEMS.isEmpty()) {
            registry.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, RatsMod.RATLANTIS_ITEMS.stream().map(ItemStack::new).toList());
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ChefRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED) {
            registry.addRecipeCategories(new IRecipeCategory[]{new ArcheologistRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_CHEF.get()), new RecipeType[]{RatsRecipeTypes.CHEF});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42544_), new RecipeType[]{RatsRecipeTypes.CAULDRON});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_CRAFTING.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)RatlantisItemRegistry.RAT_UPGRADE_ARCHEOLOGIST.get()), new RecipeType[]{RatsRecipeTypes.ARCHEOLOGIST});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)RatCraftingTableTransferHandler.INSTANCE);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)RatsItemRegistry.RAT_NUGGET_ORE.get()});
    }

    public ResourceLocation getPluginUid() {
        return MOD;
    }
}

