/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.compat.jei;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.compat.jei.CauldronInfoHolder;
import com.github.alexthe666.rats.compat.jei.RatsRecipeTypes;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CauldronRecipeCategory
implements IRecipeCategory<CauldronInfoHolder> {
    public static final int WIDTH = 170;
    public static final int HEIGHT = 75;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrowIcon;

    public CauldronRecipeCategory(IGuiHelper helper) {
        ResourceLocation location = new ResourceLocation("rats", "textures/gui/jei/cauldron_jei.png");
        this.background = helper.createDrawable(location, 0, 0, 170, 75);
        this.arrowIcon = helper.drawableBuilder(location, 170, 0, 24, 16).buildAnimated(RatConfig.milkCauldronTime, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RatsItemRegistry.CHEESE.get()));
    }

    public RecipeType<CauldronInfoHolder> getRecipeType() {
        return RatsRecipeTypes.CAULDRON;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.rats.jei.cheesemaking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CauldronInfoHolder recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 32).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(recipe.additionStack()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 77, 32).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(recipe.cauldron()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 32).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(recipe.result()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(recipe.cauldronContents()));
    }

    public void draw(CauldronInfoHolder recipe, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.additionStack().m_5456_() == Items.f_41852_) {
            this.arrowIcon.draw(graphics, 95, 31);
            MutableComponent text = Component.m_237113_((String)(RatConfig.milkCauldronTime / 20 + "s"));
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 105 - text.getString().length() * 2, 50, -8355712, false);
        }
    }
}

