/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.client.model.ChristmasChestModel;
import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RatHeldItemLayer<T extends AbstractRat, M extends AbstractRatModel<T>>
extends RenderLayer<T, M> {
    public static final ChristmasChestModel CHRISTMAS_CHEST_MODEL = new ChristmasChestModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171275_));

    public RatHeldItemLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityModel entityModel;
        if (!entity.m_6162_() && (entityModel = this.m_117386_()) instanceof RatModel) {
            RatModel model = (RatModel)entityModel;
            ItemStack itemstack = entity.m_21120_(InteractionHand.MAIN_HAND);
            if (!itemstack.m_41619_()) {
                stack.m_85836_();
                if (((AbstractRatModel)this.m_117386_()).f_102610_) {
                    stack.m_252880_(0.0f, 0.625f, 0.0f);
                    stack.m_252781_(Axis.f_252529_.m_252977_(20.0f));
                    stack.m_85841_(0.5f, 0.5f, 0.5f);
                }
                if (!((AbstractRat)((Object)entity)).isHoldingItemInHands()) {
                    ((AbstractRatModel)this.m_117386_()).translateToHead(stack);
                    stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    stack.m_252880_(0.0f, 0.35f, 0.05f);
                    stack.m_85841_(0.5f, 0.5f, 0.5f);
                    Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, stack, buffer, null, entity.m_19879_());
                } else {
                    TamedRat rat;
                    boolean flag = false;
                    boolean model3d = Minecraft.m_91087_().m_91291_().m_174264_(itemstack, (Level)Minecraft.m_91087_().f_91073_, entity, 0).m_7539_();
                    if (entity instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)((Object)entity), (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get())) {
                        this.translateToHand(model, true, stack);
                        stack.m_252880_(-0.125f, -0.15f, -0.2f);
                        if (model3d) {
                            stack.m_252781_(Axis.f_252529_.m_252977_(110.0f));
                            stack.m_252781_(Axis.f_252436_.m_252977_(10.0f));
                            stack.m_252781_(Axis.f_252393_.m_252977_(3.0f));
                            stack.m_252880_(0.0f, 0.2f, 0.025f);
                        } else {
                            stack.m_252781_(Axis.f_252529_.m_252977_(20.0f));
                            stack.m_252781_(Axis.f_252436_.m_252977_(3.0f));
                            stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
                            stack.m_252880_(0.0f, -0.025f, 0.09f);
                            stack.m_85841_(0.75f, 0.75f, 0.75f);
                        }
                        stack.m_85841_(0.5f, 0.5f, 0.5f);
                        flag = true;
                    } else {
                        this.translateToHand(model, true, stack);
                        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                        stack.m_252781_(Axis.f_252529_.m_252977_(20.0f));
                        stack.m_85841_(0.65f, 0.65f, 0.65f);
                        stack.m_252880_(0.0f, -0.075f, -0.2f);
                    }
                    Minecraft.m_91087_().m_91291_().m_269128_(itemstack, flag ? ItemDisplayContext.FIXED : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.f_118083_, stack, buffer, null, entity.m_19879_());
                    if (flag && !model3d && itemstack.m_41613_() > 5) {
                        RandomSource random = RandomSource.m_216335_((long)itemstack.m_41720_().hashCode());
                        for (int i = 0; i < itemstack.m_41613_() / 5; ++i) {
                            stack.m_85837_(0.0, 0.025, 0.0);
                            stack.m_252781_(Axis.f_252403_.m_252977_((float)random.m_216332_(-90, 90)));
                            stack.m_85837_(0.0, -0.025, 0.05);
                            Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, stack, buffer, null, entity.m_19879_());
                        }
                    }
                }
                stack.m_85849_();
            }
            if (entity instanceof TamedRat) {
                TamedRat rat = (TamedRat)((Object)entity);
                if (rat.getRespawnCountdown() > 0) {
                    stack.m_85836_();
                    Minecraft minecraft = Minecraft.m_91087_();
                    float wingAngle = 0.0f;
                    float wingFold = -45.0f;
                    ((AbstractRatModel)this.m_117386_()).translateToBody(stack);
                    stack.m_85836_();
                    stack.m_252781_(Axis.f_252393_.m_252977_(wingAngle));
                    stack.m_252781_(Axis.f_252436_.m_252977_(wingFold));
                    stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                    stack.m_252880_(0.2f, 0.0f, -0.15f);
                    minecraft.m_91291_().m_269128_(new ItemStack((ItemLike)RatsItemRegistry.FEATHERY_WING.get()), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
                    stack.m_85849_();
                    stack.m_85836_();
                    stack.m_252781_(Axis.f_252403_.m_252977_(wingAngle));
                    stack.m_252781_(Axis.f_252392_.m_252977_(wingFold));
                    stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_252880_(0.2f, -0.0f, 0.15f);
                    minecraft.m_91291_().m_269128_(new ItemStack((ItemLike)RatsItemRegistry.FEATHERY_WING.get()), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
                    stack.m_85849_();
                    stack.m_85849_();
                } else {
                    RatUpgradeUtils.forEachUpgrade(rat, item -> item instanceof HoldsItemUpgrade, (stack1, slot) -> {
                        if (rat.isSlotVisible((EquipmentSlot)slot)) {
                            stack.m_85836_();
                            ((HoldsItemUpgrade)stack1.m_41720_()).renderHeldItem(rat, model, stack, buffer, light, ageInTicks);
                            stack.m_85849_();
                        }
                    });
                }
            }
        }
    }

    protected void translateToHand(RatModel<?> model, boolean left, PoseStack stack) {
        model.body1.translateRotate(stack);
        model.body2.translateRotate(stack);
        if (left) {
            model.leftArm.translateRotate(stack);
            model.leftHand.translateRotate(stack);
        } else {
            model.rightArm.translateRotate(stack);
            model.rightHand.translateRotate(stack);
        }
    }
}

