/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.client.model.RatsModelLayers;
import com.github.alexthe666.rats.client.model.entity.PinkieModel;
import com.github.alexthe666.rats.client.model.entity.StaticRatModel;
import com.github.alexthe666.rats.client.model.hats.PartyHatModel;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.PartyHatItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PartyHatLayer<T extends LivingEntity, M extends EntityModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final A outerModel;
    private final PartyHatModel partyHat = new PartyHatModel(Minecraft.m_91087_().m_167973_().m_171103_(RatsModelLayers.PARTY_HAT));

    public PartyHatLayer(RenderLayerParent<T, M> parent, A outerModel) {
        super(parent);
        this.outerModel = outerModel;
    }

    public void render(PoseStack stack, MultiBufferSource source, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        TamedRat rat;
        ItemStack itemstack = entity.m_6844_(EquipmentSlot.HEAD);
        if (entity instanceof TamedRat && (rat = (TamedRat)((Object)entity)).getRespawnCountdown() > 0) {
            return;
        }
        Item item = itemstack.m_41720_();
        if (item instanceof PartyHatItem) {
            PartyHatItem hat = (PartyHatItem)item;
            stack.m_85836_();
            this.m_117386_().m_102624_(this.outerModel);
            this.outerModel.m_8009_(false);
            EntityModel entityModel = this.m_117386_();
            if (entityModel instanceof HumanoidModel) {
                HumanoidModel human = (HumanoidModel)entityModel;
                human.f_102808_.m_104299_(stack);
                stack.m_252880_(0.0f, -0.875f, 0.0f);
            } else {
                entityModel = this.m_117386_();
                if (entityModel instanceof StaticRatModel) {
                    StaticRatModel rat2 = (StaticRatModel)entityModel;
                    if (entity.m_6162_()) {
                        ((PinkieModel)this.m_117386_()).body.translateRotate(stack);
                        stack.m_85837_(0.0, -0.01, -0.05);
                        stack.m_85841_(0.65f, 0.65f, 0.65f);
                    } else {
                        rat2.body1.translateRotate(stack);
                        rat2.body2.translateRotate(stack);
                        rat2.neck.translateRotate(stack);
                        rat2.head.translateRotate(stack);
                    }
                    stack.m_252880_(0.0f, -0.35f, 0.0f);
                    stack.m_85841_(0.75f, 0.75f, 0.75f);
                }
            }
            boolean flag1 = itemstack.m_41790_();
            int i = hat.m_41121_(itemstack);
            this.renderModel(stack, source, light, flag1, (Model)this.partyHat, (float)(i >> 16 & 0xFF) / 255.0f, (float)(i >> 8 & 0xFF) / 255.0f, (float)(i & 0xFF) / 255.0f, new ResourceLocation("rats", "textures/model/hat/party_hat_layer_1.png"));
            i = this.invertColor(hat.m_41121_(itemstack));
            this.renderModel(stack, source, light, flag1, (Model)this.partyHat, (float)(i >> 16 & 0xFF) / 255.0f, (float)(i >> 8 & 0xFF) / 255.0f, (float)(i & 0xFF) / 255.0f, new ResourceLocation("rats", "textures/model/hat/party_hat_layer_2.png"));
            stack.m_85849_();
        }
    }

    private int invertColor(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = 255 - r;
        g = 255 - g;
        b = 255 - b;
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private void renderModel(PoseStack stack, MultiBufferSource source, int light, boolean glint, Model model, float red, float green, float blue, ResourceLocation texture) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)source, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)glint);
        model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }
}

