/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.client.model.entity.FlyingDutchratModel;
import com.github.alexthe666.rats.server.entity.monster.boss.Dutchrat;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.Nullable;

public class DutchratHelmetLayer<T extends Dutchrat, M extends FlyingDutchratModel<T>>
extends RenderLayer<T, M> {
    private final HumanoidModel<?> backup;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public DutchratHelmetLayer(RenderLayerParent<T, M> parent, HumanoidModel<?> armorModel) {
        super(parent);
        this.backup = armorModel;
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Dutchrat)((Object)rat)).getBellSummonTicks() <= 0) {
            stack.m_85836_();
            ((FlyingDutchratModel)this.m_117386_()).body1.translateRotate(stack);
            ((FlyingDutchratModel)this.m_117386_()).neck.translateRotate(stack);
            ((FlyingDutchratModel)this.m_117386_()).head.translateRotate(stack);
            stack.m_252880_(0.0f, -0.77f, 0.0f);
            ItemStack itemstack = rat.m_6844_(EquipmentSlot.HEAD);
            if (itemstack.m_41720_() instanceof ArmorItem) {
                Model model = ForgeHooksClient.getArmorModel(rat, (ItemStack)itemstack, (EquipmentSlot)EquipmentSlot.HEAD, this.backup);
                ResourceLocation tex = this.getArmorResource((Entity)rat, itemstack, EquipmentSlot.HEAD, null);
                VertexConsumer consumer = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)tex), (boolean)false, (boolean)false);
                model.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            stack.m_85849_();
        }
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

