/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.entity.FlyingDutchratModel;
import com.github.alexthe666.rats.client.render.RatsRenderType;
import com.github.alexthe666.rats.client.render.entity.layer.DutchratHelmetLayer;
import com.github.alexthe666.rats.server.entity.monster.boss.Dutchrat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DutchratRenderer
extends MobRenderer<Dutchrat, FlyingDutchratModel<Dutchrat>> {
    private static final ResourceLocation DUTCHRAT_TEXTURE = new ResourceLocation("rats", "textures/entity/dutchrat/dutchrat.png");

    public DutchratRenderer(EntityRendererProvider.Context context) {
        super(context, new FlyingDutchratModel(), 0.5f);
        this.m_115326_(new DutchratGlowLayer(this));
        this.m_115326_(new DutchratHelmetLayer(this, (HumanoidModel<?>)new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ItemInHandLayer<Dutchrat, FlyingDutchratModel<Dutchrat>>((RenderLayerParent)this, context.m_234598_()){

            public void render(PoseStack stack, MultiBufferSource buffer, int light, Dutchrat entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (!entity.hasThrownSword() && entity.getBellSummonTicks() <= 0) {
                    super.m_6494_(stack, buffer, light, (LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(Dutchrat entity) {
        return DUTCHRAT_TEXTURE;
    }

    public static class DutchratGlowLayer<T extends Dutchrat, M extends FlyingDutchratModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation GLOW_1 = new ResourceLocation("rats", "textures/entity/dutchrat/dutchrat_glow_1.png");
        private static final ResourceLocation GLOW_2 = new ResourceLocation("rats", "textures/entity/dutchrat/dutchrat_glow_2.png");

        public DutchratGlowLayer(RenderLayerParent<T, M> parent) {
            super(parent);
        }

        public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer glow1 = buffer.m_6299_(RatsRenderType.getGlowingTranslucent(GLOW_1));
            VertexConsumer glow2 = buffer.m_6299_(RatsRenderType.getGlowingTranslucent(GLOW_2));
            ((FlyingDutchratModel)this.m_117386_()).m_7695_(stack, glow1, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            ((FlyingDutchratModel)this.m_117386_()).m_7695_(stack, glow2, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
        }
    }
}

