/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.block;

import com.github.alexthe666.rats.client.model.RatsModelLayers;
import com.github.alexthe666.rats.client.model.deco.RatBreedingLanternModel;
import com.github.alexthe666.rats.client.model.deco.RatHammockModel;
import com.github.alexthe666.rats.client.model.deco.RatIglooModel;
import com.github.alexthe666.rats.client.model.deco.RatSeedBowlModel;
import com.github.alexthe666.rats.client.model.deco.RatWaterBottleModel;
import com.github.alexthe666.rats.client.model.deco.RatWheelModel;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.RatCageDecoratedBlock;
import com.github.alexthe666.rats.server.block.entity.DecoratedRatCageBlockEntity;
import com.github.alexthe666.rats.server.block.entity.RatCageBreedingLanternBlockEntity;
import com.github.alexthe666.rats.server.block.entity.RatCageWheelBlockEntity;
import com.github.alexthe666.rats.server.items.RatHammockItem;
import com.github.alexthe666.rats.server.items.RatIglooItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DecoratedRatCageRenderer
implements BlockEntityRenderer<DecoratedRatCageBlockEntity> {
    private final RatIglooModel<?> igloo;
    private final RatHammockModel<?> hammock;
    private final RatWaterBottleModel<?> water_bottle;
    private final RatSeedBowlModel<?> seed_bowl;
    private static final RatBreedingLanternModel<?> MODEL_RAT_BREEDING_LANTERN = new RatBreedingLanternModel();
    private static final RatWheelModel<?> MODEL_RAT_WHEEL = new RatWheelModel();
    private static final RenderType TEXTURE_RAT_IGLOO = RenderType.m_110473_((ResourceLocation)new ResourceLocation("rats", "textures/block/rat_igloo.png"));
    private static final RenderType TEXTURE_RAT_HAMMOCK = RenderType.m_110473_((ResourceLocation)new ResourceLocation("rats", "textures/block/rat_hammock_0.png"));
    private static final RenderType TEXTURE_RAT_WATER_BOTTLE = RenderType.m_110473_((ResourceLocation)new ResourceLocation("rats", "textures/block/rat_water_bottle.png"));
    private static final RenderType TEXTURE_RAT_SEED_BOWL = RenderType.m_110473_((ResourceLocation)new ResourceLocation("rats", "textures/block/rat_seed_bowl.png"));
    private static final RenderType TEXTURE_RAT_BREEDING_LANTERN = RenderType.m_110473_((ResourceLocation)new ResourceLocation("rats", "textures/block/rat_breeding_lantern.png"));
    private static final RenderType TEXTURE_RAT_WHEEL = RenderType.m_110473_((ResourceLocation)new ResourceLocation("rats", "textures/block/rat_wheel.png"));

    public DecoratedRatCageRenderer(BlockEntityRendererProvider.Context context) {
        this.igloo = new RatIglooModel(context.m_173582_(RatsModelLayers.IGLOO));
        this.hammock = new RatHammockModel(context.m_173582_(RatsModelLayers.HAMMOCK));
        this.water_bottle = new RatWaterBottleModel(context.m_173582_(RatsModelLayers.WATER_BOTTLE));
        this.seed_bowl = new RatSeedBowlModel(context.m_173582_(RatsModelLayers.SEED_BOWL));
    }

    public void render(DecoratedRatCageBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer consumer;
        VertexConsumer consumer2;
        Item color;
        Item item;
        BlockState blockstate = entity.m_58900_();
        stack.m_85836_();
        stack.m_85837_(0.5, 1.5, 0.5);
        float f = ((Direction)blockstate.m_61143_((Property)RatCageDecoratedBlock.FACING)).m_122427_().m_122435_() + 90.0f;
        stack.m_252781_(Axis.f_252436_.m_252977_(-f));
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        ItemStack containedItem = ItemStack.f_41583_;
        if (entity.m_58904_() != null) {
            containedItem = entity.getContainedItem();
        }
        if ((item = containedItem.m_41720_()) instanceof RatIglooItem) {
            RatIglooItem igloo = (RatIglooItem)item;
            color = igloo.color;
            VertexConsumer consumer3 = buffer.m_6299_(TEXTURE_RAT_IGLOO);
            this.igloo.m_7695_(stack, consumer3, light, overlay, color.m_41068_()[0], color.m_41068_()[1], color.m_41068_()[2], 1.0f);
        }
        if ((color = containedItem.m_41720_()) instanceof RatHammockItem) {
            RatHammockItem hammock = (RatHammockItem)color;
            consumer2 = buffer.m_6299_(TEXTURE_RAT_HAMMOCK);
            stack.m_85836_();
            DyeColor color2 = hammock.color;
            this.hammock.m_7695_(stack, consumer2, light, overlay, color2.m_41068_()[0], color2.m_41068_()[1], color2.m_41068_()[2], 1.0f);
            stack.m_85849_();
        }
        if (containedItem.m_150930_((Item)RatsItemRegistry.RAT_WATER_BOTTLE.get())) {
            consumer = buffer.m_6299_(TEXTURE_RAT_WATER_BOTTLE);
            this.water_bottle.m_7695_(stack, consumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (containedItem.m_150930_((Item)RatsItemRegistry.RAT_SEED_BOWL.get())) {
            consumer = buffer.m_6299_(TEXTURE_RAT_SEED_BOWL);
            this.seed_bowl.m_7695_(stack, consumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (containedItem.m_150930_((Item)RatsItemRegistry.RAT_WHEEL.get())) {
            consumer = buffer.m_6299_(TEXTURE_RAT_WHEEL);
            if (entity instanceof RatCageWheelBlockEntity) {
                MODEL_RAT_WHEEL.animate((RatCageWheelBlockEntity)entity, partialTicks);
            }
            MODEL_RAT_WHEEL.m_7695_(stack, consumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (containedItem.m_150930_((Item)RatsItemRegistry.RAT_BREEDING_LANTERN.get()) && entity instanceof RatCageBreedingLanternBlockEntity) {
            RatCageBreedingLanternBlockEntity lantern = (RatCageBreedingLanternBlockEntity)entity;
            consumer2 = buffer.m_6299_(TEXTURE_RAT_BREEDING_LANTERN);
            float brightness = lantern.getBreedingCooldown() > 0 ? 0.5f : 1.0f;
            MODEL_RAT_BREEDING_LANTERN.m_7695_(stack, consumer2, light, overlay, brightness, brightness, brightness, 1.0f);
            MODEL_RAT_BREEDING_LANTERN.swingChain();
        }
        stack.m_85849_();
    }
}

