/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render;

import com.github.alexthe666.rats.server.items.OreRatNuggetItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.data.ModelData;

public class NuggetColorRegister {
    public static final ItemStack FALLBACK_STACK = new ItemStack((ItemLike)Items.f_42416_);
    public static final Map<String, Integer> TEXTURES_TO_COLOR = new HashMap<String, Integer>();

    public static int getNuggetColor(ItemStack stack) {
        ItemStack poopStack = OreRatNuggetItem.getStoredItem(stack, FALLBACK_STACK);
        String poopName = poopStack.m_41611_().getString();
        if (TEXTURES_TO_COLOR.get(poopName) != null) {
            return TEXTURES_TO_COLOR.get(poopName);
        }
        int color = 0xFFFFFF;
        try {
            Color texColour = NuggetColorRegister.getAverageColour(NuggetColorRegister.getTextureAtlas(poopStack));
            color = texColour.getARGB();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        TEXTURES_TO_COLOR.put(poopName, color);
        return color;
    }

    private static Color getAverageColour(TextureAtlasSprite image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        int uMax = image.m_245424_().m_246492_();
        int vMax = image.m_245424_().m_245330_();
        for (float i = 0.0f; i < (float)uMax; i += 1.0f) {
            for (float j = 0.0f; j < (float)vMax; j += 1.0f) {
                int alpha = image.getPixelRGBA(0, (int)i, (int)j) >> 24 & 0xFF;
                if (alpha != 255) continue;
                red += (float)(image.getPixelRGBA(0, (int)i, (int)j) & 0xFF);
                green += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 8 & 0xFF);
                blue += (float)(image.getPixelRGBA(0, (int)i, (int)j) >> 16 & 0xFF);
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(ItemStack oreStack) {
        return Objects.requireNonNull(Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(oreStack.m_41720_())).getParticleIcon(ModelData.EMPTY);
    }

    public static class Color {
        private final int value;

        public Color(int r, int g, int b) {
            this(r, g, b, 255);
        }

        public Color(int r, int g, int b, int a) {
            this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        public int getARGB() {
            return this.value;
        }
    }
}

