/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.rats.server.entity.monster.boss.BlackDeath;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BlackDeathModel<T extends BlackDeath>
extends HumanoidModel<T> {
    public final ModelPart arms;

    public BlackDeathModel(ModelPart root) {
        super(root);
        this.arms = root.m_171324_("arms");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f).m_171514_(18, 6).m_171481_(-7.0f, -7.0f, -7.0f, 14.0f, 0.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(28, 42).m_171481_(-1.5f, -2.0f, -5.5f, 3.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        nose.m_171599_("nose2", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -4.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-5.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(44, 22).m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        if (((BlackDeath)entity).isSummoning()) {
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.f_102811_.f_104205_ = 2.3561945f;
            this.f_102812_.f_104205_ = -2.3561945f;
            this.f_102811_.f_104204_ = (float)Math.PI;
            this.f_102812_.f_104204_ = (float)Math.PI;
        } else if (((BlackDeath)entity).isMeleeAttacking()) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entity, (float)this.f_102608_, (float)ageInTicks);
        } else {
            this.f_102811_.m_171327_(0.0f, 0.0f, 0.0f);
            this.f_102812_.m_171327_(0.0f, 0.0f, 0.0f);
        }
        boolean flag = ((BlackDeath)entity).isSummoning() || ((BlackDeath)entity).isMeleeAttacking();
        this.arms.f_104207_ = !flag;
        this.f_102812_.f_104207_ = flag;
        this.f_102811_.f_104207_ = flag;
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.arms));
    }
}

