/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.client.util.EntityRenderingUtil;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.SyncRatStaffPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CheeseStaffScreen
extends Screen {
    private final TamedRat rat;
    private final BlockPos pos;
    private final Direction clickedFace;

    public CheeseStaffScreen(TamedRat rat, BlockPos pos, Direction clickedFace) {
        super((Component)Component.m_237115_((String)((Item)RatsItemRegistry.CHEESE_STICK.get()).m_5524_()));
        this.rat = rat;
        this.pos = pos;
        this.clickedFace = clickedFace;
        this.m_7856_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int i = this.f_96543_ / 2;
        int j = (this.f_96544_ - 166) / 2;
        MutableComponent topText = Component.m_237110_((String)"item.rats.cheese_staff.mark_deposit", (Object[])new Object[]{this.getPosName(), Component.m_237115_((String)("rats.direction." + this.clickedFace.m_122433_()))});
        int maxLength = Math.max(150, Minecraft.m_91087_().f_91062_.m_92895_(topText.getString()) + 20);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)topText, button -> {
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SyncRatStaffPacket(this.rat.m_19879_(), this.pos, this.clickedFace, 0));
            Minecraft.m_91087_().m_91152_(null);
            this.m_7856_();
        }).m_252987_(i - maxLength / 2, j + 60, maxLength, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237110_((String)"item.rats.cheese_staff.mark_pickup", (Object[])new Object[]{this.getPosName()}), button -> {
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SyncRatStaffPacket(this.rat.m_19879_(), this.pos, Direction.UP, 1));
            Minecraft.m_91087_().m_91152_(null);
            this.m_7856_();
        }).m_252987_(i - maxLength / 2, j + 85, maxLength, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237110_((String)"item.rats.cheese_staff.mark_home", (Object[])new Object[]{this.getPosName()}), button -> {
            this.rat.setHomePoint(GlobalPos.m_122643_((ResourceKey)Minecraft.m_91087_().f_91074_.m_9236_().m_46472_(), (BlockPos)this.pos));
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SyncRatStaffPacket(this.rat.m_19879_(), this.pos, Direction.UP, 2));
            this.m_7856_();
        }).m_252987_(i - maxLength / 2, j + 110, maxLength, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"item.rats.cheese_staff.unmark_home"), button -> {
            this.rat.setHomePoint(null);
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SyncRatStaffPacket(this.rat.m_19879_(), this.pos, Direction.UP, 3));
            this.m_7856_();
        }).m_252987_(i - maxLength / 2, j + 135, maxLength, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"item.rats.cheese_staff.unmark_transport"), button -> {
            this.rat.setPickupPos(null);
            this.rat.setDepositPos(null);
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SyncRatStaffPacket(this.rat.m_19879_(), this.pos, Direction.UP, 7));
            this.m_7856_();
        }).m_252987_(i - maxLength / 2, j + 160, maxLength, 20).m_253136_());
        ((Button)this.f_169369_.get((int)0)).f_93624_ = !this.isNoInventoryAtPos();
        ((Button)this.f_169369_.get((int)1)).f_93624_ = !this.isNoInventoryAtPos();
        ((Button)this.f_169369_.get((int)2)).f_93624_ = this.rat.getHomePoint().isEmpty() || !this.rat.getHomePoint().get().m_122646_().equals((Object)this.pos);
        ((Button)this.f_169369_.get((int)3)).f_93624_ = this.rat.getHomePoint().isPresent();
        ((Button)this.f_169369_.get((int)4)).f_93624_ = this.rat.getDepositPos().isPresent() || this.rat.getPickupPos().isPresent();
    }

    private String getPosName() {
        if (this.pos != null) {
            BlockState state = this.rat.m_9236_().m_8055_(this.pos);
            List namelist = null;
            ItemStack pick = state.m_60734_().m_7397_((BlockGetter)this.rat.m_9236_(), this.pos, state);
            try {
                namelist = pick.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (namelist != null && !namelist.isEmpty()) {
                return ((Component)namelist.get(0)).getString();
            }
        }
        return "";
    }

    private boolean isNoInventoryAtPos() {
        if (this.pos != null) {
            Level level = this.rat.m_9236_();
            return level.m_7702_(this.pos) == null;
        }
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, x, y, partialTicks);
        int i = (this.f_96543_ - 248) / 2 + 10;
        int j = (this.f_96544_ - 166) / 2 + 8;
        if (this.rat != null) {
            EntityRenderingUtil.drawEntityOnScreen(graphics, i + 114, j + 40, 70, 0.0f, 0.0f, (LivingEntity)this.rat, true);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

