/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.proxy;

import com.jahirtrap.walljump.init.WallJumpModConfig;
import com.jahirtrap.walljump.logic.DoubleJumpLogic;
import com.jahirtrap.walljump.logic.FallingSound;
import com.jahirtrap.walljump.logic.SpeedBoostLogic;
import com.jahirtrap.walljump.logic.WallJumpLogic;
import com.jahirtrap.walljump.proxy.CommonProxy;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    public static KeyMapping KEY_WALL_JUMP = new KeyMapping("key.walljump.walljump", 340, "key.categories.walljump");
    private static FallingSound FALLING_SOUND;

    public static boolean collidesWithBlock(Level level, AABB box) {
        return !level.m_45772_(box);
    }

    @Override
    public void setupClient() {
        RegisterKeyMappingsEvent event = new RegisterKeyMappingsEvent(ClientProxy.minecraft.f_91066_);
        event.register(KEY_WALL_JUMP);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer pl = ClientProxy.minecraft.f_91074_;
        if (event.phase != TickEvent.Phase.END || pl == null) {
            return;
        }
        WallJumpLogic.doWallJump(pl);
        DoubleJumpLogic.doDoubleJump(pl);
        SpeedBoostLogic.doSpeedBoost(pl);
        if (pl.f_19862_ && WallJumpModConfig.stepAssist && pl.m_20184_().f_82480_ > -0.2 && pl.m_20184_().f_82480_ < 0.01 && !ClientProxy.collidesWithBlock(pl.m_9236_(), pl.m_20191_().m_82377_(0.01, (double)(-pl.m_274421_()) + 0.02, 0.01))) {
            pl.m_6853_(true);
        }
        if (pl.m_20142_() && pl.m_20184_().m_82553_() > 0.08) {
            pl.f_19862_ = false;
        }
        if ((double)pl.f_19789_ > 1.5 && !pl.m_21255_() && WallJumpModConfig.playFallSound && (FALLING_SOUND == null || FALLING_SOUND.m_7801_())) {
            FALLING_SOUND = new FallingSound(pl);
            minecraft.m_91106_().m_120367_((SoundInstance)FALLING_SOUND);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() == ClientProxy.minecraft.f_91074_ && WallJumpModConfig.playFallSound) {
            FALLING_SOUND = new FallingSound(ClientProxy.minecraft.f_91074_);
            minecraft.m_91106_().m_120367_((SoundInstance)FALLING_SOUND);
        }
    }
}

