/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.walljump.logic;

import com.jahirtrap.walljump.init.WallJumpEnchantments;
import com.jahirtrap.walljump.init.WallJumpModConfig;
import com.jahirtrap.walljump.network.PacketHandler;
import com.jahirtrap.walljump.network.message.MessageFallDistance;
import com.jahirtrap.walljump.network.message.MessageWallJump;
import com.jahirtrap.walljump.proxy.ClientProxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WallJumpLogic {
    public static int ticksWallClinged;
    public static int ticksWallSlid;
    public static boolean stopSlid;
    private static int ticksKeyDown;
    private static double clingX;
    private static double clingZ;
    private static double lastJumpY;
    private static Set<Direction> walls;
    private static Set<Direction> staleWalls;

    public static void doWallJump(LocalPlayer pl) {
        if (!WallJumpLogic.canWallJump(pl)) {
            return;
        }
        if (pl.m_20096_() || pl.m_150110_().f_35935_ || !pl.m_9236_().m_6425_(pl.m_20183_()).m_76178_() || pl.m_108637_()) {
            ticksWallClinged = 0;
            ticksWallSlid = 0;
            stopSlid = false;
            clingX = Double.NaN;
            clingZ = Double.NaN;
            lastJumpY = Double.MAX_VALUE;
            staleWalls.clear();
            return;
        }
        if (stopSlid) {
            return;
        }
        WallJumpLogic.updateWalls(pl);
        int n = ticksKeyDown = ClientProxy.KEY_WALL_JUMP.m_90857_() ? ticksKeyDown + 1 : 0;
        if (ticksWallClinged < 1) {
            if (ticksKeyDown > 0 && ticksKeyDown < 4 && !walls.isEmpty() && WallJumpLogic.canWallCling(pl)) {
                if (WallJumpModConfig.autoRotation) {
                    pl.m_146922_(WallJumpLogic.getClingDirection().m_122424_().m_122435_());
                    pl.f_19859_ = pl.m_146908_();
                }
                ticksWallClinged = 1;
                clingX = pl.m_20185_();
                clingZ = pl.m_20189_();
                WallJumpLogic.playHitSound((Entity)pl, WallJumpLogic.getWallPos(pl));
                WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
            }
            return;
        }
        if (!ClientProxy.KEY_WALL_JUMP.m_90857_() || pl.m_20096_() || !pl.m_9236_().m_6425_(pl.m_20183_()).m_76178_() || walls.isEmpty() || pl.m_36324_().m_38702_() < 1) {
            ticksWallClinged = 0;
            if (!(pl.f_108618_.f_108567_ == 0.0f && pl.f_108618_.f_108566_ == 0.0f || pl.m_20096_() || walls.isEmpty())) {
                pl.m_183634_();
                PacketHandler.INSTANCE.sendToServer((Object)new MessageWallJump());
                WallJumpLogic.wallJump(pl, (float)WallJumpModConfig.wallJumpHeight);
                staleWalls = new HashSet<Direction>(walls);
            }
            return;
        }
        pl.m_6034_(clingX, pl.m_20186_(), clingZ);
        double motionY = pl.m_20184_().f_82480_;
        if (motionY > 0.0) {
            motionY = 0.0;
        } else if (motionY < -0.6) {
            motionY += 0.2;
            WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        } else if (ticksWallClinged++ > WallJumpModConfig.wallSlideDelay) {
            if (ticksWallSlid++ > WallJumpModConfig.stopWallSlideDelay) {
                stopSlid = true;
            }
            motionY = -0.1;
            WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        } else {
            motionY = 0.0;
        }
        if (pl.f_19789_ > 2.0f) {
            pl.m_183634_();
            PacketHandler.INSTANCE.sendToServer((Object)new MessageFallDistance((float)(motionY * motionY * 8.0)));
        }
        pl.m_20334_(0.0, motionY, 0.0);
    }

    private static boolean canWallJump(LocalPlayer pl) {
        if (WallJumpModConfig.useWallJump) {
            return true;
        }
        ItemStack stack = pl.m_6844_(EquipmentSlot.FEET);
        if (!stack.m_41619_()) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            return enchantments.containsKey(WallJumpEnchantments.WALL_JUMP.get());
        }
        return false;
    }

    private static boolean canWallCling(LocalPlayer pl) {
        if (pl.m_6147_() || pl.m_20184_().f_82480_ > 0.1 || pl.m_36324_().m_38702_() < 1) {
            return false;
        }
        if (ClientProxy.collidesWithBlock(pl.m_9236_(), pl.m_20191_().m_82386_(0.0, -0.8, 0.0))) {
            return false;
        }
        if (WallJumpModConfig.allowReClinging || pl.m_20186_() < lastJumpY - 1.0) {
            return true;
        }
        return !staleWalls.containsAll(walls);
    }

    private static void updateWalls(LocalPlayer pl) {
        Vec3 pos = pl.m_20182_();
        AABB box = new AABB(pos.f_82479_ - 0.001, pos.f_82480_, pos.f_82481_ - 0.001, pos.f_82479_ + 0.001, pos.f_82480_ + (double)pl.m_20192_(), pos.f_82481_ + 0.001);
        double dist = (double)(pl.m_20205_() / 2.0f) + (ticksWallClinged > 0 ? 0.1 : 0.06);
        AABB[] axes = new AABB[]{box.m_82363_(0.0, 0.0, dist), box.m_82363_(-dist, 0.0, 0.0), box.m_82363_(0.0, 0.0, -dist), box.m_82363_(dist, 0.0, 0.0)};
        int i = 0;
        walls = new HashSet<Direction>();
        for (AABB axis : axes) {
            Direction direction = Direction.m_122407_((int)i++);
            if (!ClientProxy.collidesWithBlock(pl.m_9236_(), axis)) continue;
            walls.add(direction);
            pl.f_19862_ = true;
        }
    }

    private static Direction getClingDirection() {
        return walls.isEmpty() ? Direction.UP : walls.iterator().next();
    }

    private static BlockPos getWallPos(LocalPlayer player) {
        BlockPos blockPos = player.m_20097_().m_121945_(WallJumpLogic.getClingDirection());
        return player.m_9236_().m_8055_(blockPos).m_280296_() ? blockPos : blockPos.m_121945_(Direction.UP);
    }

    private static void wallJump(LocalPlayer pl, float up) {
        float strafe = Math.signum(pl.f_108618_.f_108566_) * up * up;
        float forward = Math.signum(pl.f_108618_.f_108567_) * up * up;
        float f = (float)(1.0 / Math.sqrt(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = (float)(Math.sin(pl.m_146908_() * ((float)Math.PI / 180)) * (double)0.45f);
        float f2 = (float)(Math.cos(pl.m_146908_() * ((float)Math.PI / 180)) * (double)0.45f);
        int jumpBoostLevel = 0;
        MobEffectInstance jumpBoostEffect = pl.m_21124_(MobEffects.f_19603_);
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.m_19564_() + 1;
        }
        Vec3 motion = pl.m_20184_();
        pl.m_20334_(motion.f_82479_ + (double)(strafe * f2 - forward * f1), (double)up + (double)jumpBoostLevel * 0.125, motion.f_82481_ + (double)(forward * f2 + strafe * f1));
        lastJumpY = pl.m_20186_();
        WallJumpLogic.playBreakSound((Entity)pl, WallJumpLogic.getWallPos(pl));
        WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
    }

    private static void playHitSound(Entity entity, BlockPos blockPos) {
        BlockState state = entity.m_9236_().m_8055_(blockPos);
        SoundType soundtype = state.m_60734_().getSoundType(state, (LevelReader)entity.m_9236_(), blockPos, entity);
        entity.m_5496_(soundtype.m_56778_(), soundtype.m_56773_() * 0.25f, soundtype.m_56774_());
    }

    private static void playBreakSound(Entity entity, BlockPos blockPos) {
        BlockState state = entity.m_9236_().m_8055_(blockPos);
        SoundType soundtype = state.m_60734_().getSoundType(state, (LevelReader)entity.m_9236_(), blockPos, entity);
        entity.m_5496_(soundtype.m_56779_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_());
    }

    private static void spawnWallParticle(Entity entity, BlockPos blockPos) {
        BlockState state = entity.m_9236_().m_8055_(blockPos);
        if (state.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 pos = entity.m_20182_();
            Vec3i motion = WallJumpLogic.getClingDirection().m_122436_();
            entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(blockPos), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)motion.m_123341_() * -1.0, -1.0, (double)motion.m_123343_() * -1.0);
        }
    }

    static {
        stopSlid = false;
        lastJumpY = Double.MAX_VALUE;
        walls = new HashSet<Direction>();
        staleWalls = new HashSet<Direction>();
    }
}

