/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.zeta.client.event.play.ZInputUpdate;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.event.play.loading.ZGatherHints;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.RegistryUtil;

@ZetaLoadModule(category="tweaks")
public class EnhancedLaddersModule
extends ZetaModule {
    @Config.Max(value=0.0)
    @Config
    public double fallSpeed = -0.2;
    @Config
    public static boolean allowFreestanding = true;
    @Config
    public static boolean allowDroppingDown = true;
    @Config
    public static boolean allowSliding = true;
    @Config
    public static boolean allowInventorySneak = true;
    private static boolean staticEnabled;
    private static TagKey<Item> laddersTag;
    private static TagKey<Block> laddersBlockTag;

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        laddersTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "ladders"));
        laddersBlockTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "ladders"));
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints event) {
        if (!(allowFreestanding || allowDroppingDown || allowSliding || allowInventorySneak)) {
            return;
        }
        MutableComponent comp = Component.m_237119_();
        String pad = "";
        if (allowDroppingDown) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_dropping"));
            pad = " ";
        }
        if (allowFreestanding) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_freestanding"));
            pad = " ";
        }
        if (allowSliding) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_sliding"));
            pad = " ";
        }
        if (allowInventorySneak) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_sneak"));
        }
        List ladders = RegistryUtil.getTagValues((RegistryAccess)event.getRegistryAccess(), laddersTag);
        for (Item item : ladders) {
            event.accept((ItemLike)item, (Component)comp);
        }
    }

    private static boolean canAttachTo(BlockState state, Block ladder, LevelReader world, BlockPos pos, Direction facing) {
        if (ladder instanceof LadderBlock) {
            if (allowFreestanding) {
                return EnhancedLaddersModule.canLadderSurvive(state, world, pos);
            }
            BlockPos offset = pos.m_121945_(facing);
            BlockState blockstate = world.m_8055_(offset);
            return !blockstate.m_60803_() && blockstate.m_60783_((BlockGetter)world, offset, facing);
        }
        return false;
    }

    public static boolean canLadderSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (!staticEnabled || !allowFreestanding) {
            return false;
        }
        if (!state.m_204336_(laddersBlockTag)) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)LadderBlock.f_54337_);
        Direction opposite = facing.m_122424_();
        BlockPos oppositePos = pos.m_121945_(opposite);
        BlockState oppositeState = world.m_8055_(oppositePos);
        boolean solid = oppositeState.m_60783_((BlockGetter)world, oppositePos, facing) && !(oppositeState.m_60734_() instanceof LadderBlock);
        BlockState topState = world.m_8055_(pos.m_7494_());
        return solid || topState.m_60734_() instanceof LadderBlock && (facing.m_122434_() == Direction.Axis.Y || topState.m_61143_((Property)LadderBlock.f_54337_) == facing);
    }

    @PlayEvent
    public void onInteract(ZRightClickBlock event) {
        InteractionHand hand;
        if (!allowDroppingDown) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = player.m_21120_(hand = event.getHand());
        if (!stack.m_41619_() && stack.m_204117_(laddersTag)) {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            Level world = event.getLevel();
            BlockPos pos = event.getPos();
            while (world.m_8055_(pos).m_60734_() == block) {
                Direction facing;
                BlockState copyState;
                boolean water;
                event.setCanceled(true);
                BlockPos posDown = pos.m_7495_();
                if (world.m_151570_(posDown)) break;
                BlockState stateDown = world.m_8055_(posDown);
                if (stateDown.m_60734_() == block) {
                    pos = posDown;
                    continue;
                }
                boolean bl = water = stateDown.m_60734_() == Blocks.f_49990_;
                if (!water && !stateDown.m_60795_() || !EnhancedLaddersModule.canAttachTo(copyState = world.m_8055_(pos), block, (LevelReader)world, posDown, (facing = (Direction)copyState.m_61143_((Property)LadderBlock.f_54337_)).m_122424_())) break;
                world.m_46597_(posDown, (BlockState)copyState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(water)));
                world.m_6263_(null, (double)posDown.m_123341_(), (double)posDown.m_123342_(), (double)posDown.m_123343_(), SoundEvents.f_12023_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (stack.m_41613_() <= 0) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.f_46443_));
                break;
            }
        }
    }

    protected boolean isScaffolding(BlockState state, LivingEntity entity) {
        return this.zeta.blockExtensions.get(state).isScaffoldingZeta(state, (LevelReader)entity.m_9236_(), entity.m_20183_(), entity);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends EnhancedLaddersModule {
        @PlayEvent
        public void onInput(ZInputUpdate event) {
            Input input;
            if (!allowInventorySneak) {
                return;
            }
            Player player = event.getEntity();
            if (!(!player.m_6147_() || player.m_150110_().f_35935_ || this.isScaffolding(player.m_9236_().m_8055_(player.m_20183_()), (LivingEntity)player) || Minecraft.m_91087_().f_91080_ == null || player.f_20902_ == 0.0f && player.m_146909_() > 70.0f || player.m_20096_() || (input = event.getInput()) == null)) {
                input.f_108573_ = true;
            }
        }

        @PlayEvent
        public void onPlayerTick(ZPlayerTick.Start event) {
            if (!allowSliding) {
                return;
            }
            Player player = event.getPlayer();
            if (player.m_6147_() && player.m_9236_().f_46443_) {
                BlockPos playerPos = player.m_20183_();
                BlockPos downPos = playerPos.m_7495_();
                boolean scaffold = this.isScaffolding(player.m_9236_().m_8055_(playerPos), (LivingEntity)player);
                if (player.m_6047_() == scaffold && player.f_20902_ == 0.0f && player.f_20901_ <= 0.0f && player.f_20900_ == 0.0f && player.m_146909_() > 70.0f && !player.f_20899_ && !player.m_150110_().f_35935_ && player.m_9236_().m_8055_(downPos).isLadder((LevelReader)player.m_9236_(), downPos, (LivingEntity)player)) {
                    Vec3 move = new Vec3(0.0, this.fallSpeed, 0.0);
                    AABB target = player.m_20191_().m_82383_(move);
                    Iterable collisions = player.m_9236_().m_186434_((Entity)player, target);
                    if (!collisions.iterator().hasNext()) {
                        player.m_20011_(target);
                        player.m_6478_(MoverType.SELF, move);
                    }
                }
            }
        }
    }
}

