/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.client.render.entity.PickarangRenderer;
import org.violetmoon.quark.content.tools.config.PickarangType;
import org.violetmoon.quark.content.tools.entity.rang.AbstractPickarang;
import org.violetmoon.quark.content.tools.entity.rang.Flamerang;
import org.violetmoon.quark.content.tools.entity.rang.Pickarang;
import org.violetmoon.quark.content.tools.item.PickarangItem;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class PickarangModule
extends ZetaModule {
    @Config(name="pickarang")
    public static PickarangType<Pickarang> pickarangType = new PickarangType(Items.f_42415_, Items.f_42390_, 20, 3, 800, 20.0, 2, 10);
    @Config(name="flamerang")
    public static PickarangType<Flamerang> flamerangType = new PickarangType(Items.f_42418_, Items.f_42395_, 20, 4, 1040, 20.0, 3, 10);
    @Config(flag="flamerang")
    public static boolean enableFlamerang = true;
    @Config(description="Set this to true to use the recipe without the Heart of Diamond, even if the Heart of Diamond is enabled.", flag="pickarang_never_uses_heart")
    public static boolean neverUseHeartOfDiamond = false;
    @Hint
    public static Item pickarang;
    @Hint(value="flamerang")
    public static Item flamerang;
    private static List<PickarangType<?>> knownTypes;
    private static boolean isEnabled;
    public static final TagKey<Block> pickarangImmuneTag;
    public static ManualTrigger throwPickarangTrigger;
    public static ManualTrigger useFlamerangTrigger;
    private static final ThreadLocal<AbstractPickarang<?>> ACTIVE_PICKARANG;

    @LoadEvent
    public final void register(ZRegister event) {
        pickarang = this.makePickarang(pickarangType, "pickarang", Pickarang::new, Pickarang::new, BooleanSuppliers.TRUE).setCreativeTab(CreativeModeTabs.f_256869_, (ItemLike)Items.f_42392_, false);
        flamerang = this.makePickarang(flamerangType, "flamerang", Flamerang::new, Flamerang::new, () -> enableFlamerang).setCreativeTab(CreativeModeTabs.f_256869_, (ItemLike)Items.f_42397_, false);
        throwPickarangTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("throw_pickarang");
        useFlamerangTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("use_flamerang");
    }

    private <T extends AbstractPickarang<T>> PickarangItem makePickarang(PickarangType<T> type, String name, EntityType.EntityFactory<T> entityFactory, PickarangType.PickarangConstructor<T> thrownFactory, BooleanSupplier condition) {
        EntityType entityType = EntityType.Builder.m_20704_(entityFactory, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.4f).m_20702_(4).m_20717_(10).setCustomClientFactory((t, l) -> (AbstractPickarang)entityFactory.m_20721_(type.getEntityType(), l)).m_20712_(name);
        Quark.ZETA.registry.register((Object)entityType, name, Registries.f_256939_);
        knownTypes.add(type);
        type.setEntityType(entityType, thrownFactory);
        return (PickarangItem)new PickarangItem(name, this, this.propertiesFor(type.durability, type.isFireResistant()), type).setCondition(condition);
    }

    private Item.Properties propertiesFor(int durability, boolean fireResist) {
        Item.Properties properties = new Item.Properties().m_41487_(1);
        if (durability > 0) {
            properties.m_41503_(durability);
        }
        if (fireResist) {
            properties.m_41486_();
        }
        return properties;
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        isEnabled = this.enabled;
    }

    public static void setActivePickarang(AbstractPickarang<?> pickarang) {
        ACTIVE_PICKARANG.set(pickarang);
    }

    public static DamageSource createDamageSource(Player player) {
        AbstractPickarang<?> pickarang = ACTIVE_PICKARANG.get();
        if (pickarang == null) {
            return null;
        }
        return player.m_9236_().m_269111_().m_269104_(pickarang, (Entity)player);
    }

    public static boolean getIsFireResistant(boolean vanillaVal, Entity entity) {
        if (!isEnabled || vanillaVal) {
            return vanillaVal;
        }
        Entity riding = entity.m_20202_();
        if (riding instanceof AbstractPickarang) {
            AbstractPickarang pick = (AbstractPickarang)riding;
            return pick.getPickarangType().isFireResistant();
        }
        return false;
    }

    static {
        knownTypes = new ArrayList();
        pickarangImmuneTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "pickarang_immune"));
        ACTIVE_PICKARANG = new ThreadLocal();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends PickarangModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            knownTypes.forEach(t -> EntityRenderers.m_174036_(t.getEntityType(), PickarangRenderer::new));
        }
    }
}

