/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.bus.ZResult;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.ZAnvilUpdate;
import org.violetmoon.zeta.event.play.ZItemTooltip;
import org.violetmoon.zeta.event.play.entity.ZEntityMobGriefing;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDrops;
import org.violetmoon.zeta.event.play.entity.living.ZLivingTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="experimental", enabledByDefault=false)
public class GameNerfsModule
extends ZetaModule {
    private static final String TAG_TRADES_ADJUSTED = "quark:zombie_trades_adjusted";
    @Config(description="Makes Mending act like the Unmending mod\nhttps://www.curseforge.com/minecraft/mc-mods/unmending")
    public static boolean nerfMending = true;
    @Config(name="No Nerf for Mending II", description="Makes Mending II still work even if mending is nerfed.\nIf you want Mending II, disable the sanity check on Ancient Tomes and add minecraft:mending to the tomes.")
    public static boolean noNerfForMendingTwo = false;
    @Config(description="Resets all villager discounts when zombified to prevent reducing prices to ridiculous levels")
    public static boolean nerfVillagerDiscount = true;
    @Config(description="Makes Iron Golems not drop Iron Ingots")
    public static boolean disableIronFarms = true;
    @Config(description="Makes Boats not glide on ice")
    public static boolean disableIceRoads = true;
    @Config(description="Makes Sheep not drop Wool when killed")
    public static boolean disableWoolDrops = true;
    @Config(description="Disables mob griefing for only specific entities")
    public static boolean enableSelectiveMobGriefing = true;
    @Config(description="Force Elytra to only work in specific dimensions")
    public static boolean enableDimensionLockedElytra = true;
    @Config(description="Makes falling blocks not able to be duped via dimension crossing")
    public static boolean disableFallingBlockDupe = true;
    @Config(description="Fixes several piston physics exploits, most notably including TNT duping")
    public static boolean disablePistonPhysicsExploits = true;
    @Config(description="Fixes mushroom growth being able to replace blocks")
    public static boolean disableMushroomBlockRemoval = true;
    @Config(description="Makes tripwire hooks unable to be duplicated")
    public static boolean disableTripwireHookDupe = true;
    @Config
    public static List<String> nonGriefingEntities = Arrays.asList("minecraft:creeper", "minecraft:enderman");
    @Config
    public static List<String> elytraAllowedDimensions = Arrays.asList("minecraft:the_end");
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    public static float getBoatFriction(float glide) {
        return staticEnabled && disableIceRoads ? 0.45f : glide;
    }

    public static boolean canEntityUseElytra(LivingEntity entity, boolean prev) {
        if (!prev) {
            return false;
        }
        if (!staticEnabled || !enableDimensionLockedElytra) {
            return true;
        }
        Level level = entity.m_9236_();
        String dim = level.m_220362_().m_135782_().toString();
        return elytraAllowedDimensions.contains(dim);
    }

    public static boolean stopFallingBlocksDuping() {
        return staticEnabled && disableFallingBlockDupe;
    }

    public static boolean stopPistonPhysicsExploits() {
        return staticEnabled && disablePistonPhysicsExploits;
    }

    public static boolean shouldMushroomsUseTreeReplacementLogic() {
        return staticEnabled && disableMushroomBlockRemoval;
    }

    public static boolean shouldTripwireHooksCheckForAir() {
        return staticEnabled && disableTripwireHookDupe;
    }

    @PlayEvent
    public void onMobGriefing(ZEntityMobGriefing event) {
        if (!enableSelectiveMobGriefing || event.getEntity() == null) {
            return;
        }
        String name = BuiltInRegistries.f_256780_.m_7981_((Object)event.getEntity().m_6095_()).toString();
        if (nonGriefingEntities.contains(name)) {
            event.setResult(ZResult.DENY);
        }
    }

    public static Predicate<ItemStack> limitMendingItems(Predicate<ItemStack> base) {
        if (!staticEnabled || !nerfMending) {
            return base;
        }
        if (noNerfForMendingTwo) {
            return stack -> base.test((ItemStack)stack) && Quark.ZETA.itemExtensions.get(stack).getEnchantmentLevelZeta(stack, Enchantments.f_44962_) > 1;
        }
        return stack -> false;
    }

    private boolean isMending(Map<Enchantment, Integer> enchantments) {
        return enchantments.containsKey(Enchantments.f_44962_) && (!noNerfForMendingTwo || enchantments.get(Enchantments.f_44962_) < 2);
    }

    @PlayEvent
    public void onAnvilUpdate(ZAnvilUpdate event) {
        if (!nerfMending) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack out = event.getOutput();
        if (out.m_41619_() && (left.m_41619_() || right.m_41619_())) {
            return;
        }
        boolean isMended = false;
        Map enchLeft = EnchantmentHelper.m_44831_((ItemStack)left);
        Map enchRight = EnchantmentHelper.m_44831_((ItemStack)right);
        if (this.isMending(enchLeft) || this.isMending(enchRight)) {
            if (left.m_41720_() == right.m_41720_()) {
                isMended = true;
            }
            if (right.m_41720_() == Items.f_42690_) {
                isMended = true;
            }
        }
        if (isMended) {
            if (out.m_41619_()) {
                out = left.m_41777_();
            }
            if (!out.m_41782_()) {
                out.m_41751_(new CompoundTag());
            }
            Map enchOutput = EnchantmentHelper.m_44831_((ItemStack)out);
            for (Enchantment enchantment : enchRight.keySet()) {
                if (!enchantment.m_6081_(out)) continue;
                int level = (Integer)enchRight.get(enchantment);
                if (enchOutput.containsKey(enchantment)) {
                    int levelPresent = (Integer)enchOutput.get(enchantment);
                    if (level > levelPresent) {
                        enchOutput.put(enchantment, level);
                        continue;
                    }
                    if (level != levelPresent || enchantment.m_6586_() <= level) continue;
                    enchOutput.put(enchantment, level + 1);
                    continue;
                }
                enchOutput.put(enchantment, level);
            }
            if (this.isMending(enchOutput)) {
                enchOutput.remove(Enchantments.f_44962_);
            }
            EnchantmentHelper.m_44865_((Map)enchOutput, (ItemStack)out);
            out.m_41742_(0);
            if (out.m_41763_()) {
                out.m_41721_(0);
            }
            event.setOutput(out);
            event.setCost(5);
        }
    }

    @PlayEvent
    public void onTick(ZLivingTick event) {
        if (nerfVillagerDiscount && event.getEntity().m_6095_() == EntityType.f_20530_ && !event.getEntity().getPersistentData().m_128441_(TAG_TRADES_ADJUSTED)) {
            ZombieVillager zombie = (ZombieVillager)event.getEntity();
            Tag gossipsNbt = zombie.f_34361_;
            GossipContainer manager = new GossipContainer();
            manager.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)gossipsNbt));
            for (UUID uuid : manager.f_26156_.keySet()) {
                GossipContainer.EntityGossips gossips = (GossipContainer.EntityGossips)manager.f_26156_.get(uuid);
                gossips.m_26226_(GossipType.MAJOR_POSITIVE);
                gossips.m_26226_(GossipType.MINOR_POSITIVE);
            }
            zombie.f_34361_ = (Tag)manager.m_262795_((DynamicOps)NbtOps.f_128958_);
            zombie.getPersistentData().m_128379_(TAG_TRADES_ADJUSTED, true);
        }
    }

    @PlayEvent
    public void onLoot(ZLivingDrops event) {
        if (disableIronFarms && event.getEntity().m_6095_() == EntityType.f_20460_) {
            event.getDrops().removeIf(e -> e.m_32055_().m_41720_() == Items.f_42416_);
        }
        if (disableWoolDrops && event.getEntity().m_6095_() == EntityType.f_20520_) {
            event.getDrops().removeIf(e -> e.m_32055_().m_204117_(ItemTags.f_13167_));
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends GameNerfsModule {
        @PlayEvent
        public void onTooltip(ZItemTooltip event) {
            if (!nerfMending) {
                return;
            }
            MutableComponent itemgotmodified = Component.m_237115_((String)"quark.misc.repaired").m_130940_(ChatFormatting.YELLOW);
            int repairCost = event.getItemStack().m_41610_();
            if (repairCost > 0) {
                event.getToolTip().add(itemgotmodified);
            }
        }
    }
}

