/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.violetmoon.quark.addons.oddities.block.MagnetBlock;
import org.violetmoon.quark.addons.oddities.client.particle.MagnetParticleRenderType;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;

public class MagnetParticle
extends TextureSheetParticle {
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);
    private float xWobble = 0.0f;
    private float xWobbleO = 0.0f;
    private float yWobble = 0.0f;
    private float yWobbleO = 0.0f;
    private float alphaO = 0.0f;

    public MagnetParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.f_107225_ = 33;
        this.f_172258_ = 1.0f;
        this.m_107250_(0.01f, 0.01f);
        this.f_107230_ = 0.0f;
        this.updateAlpha();
    }

    private void updateAlpha() {
        this.alphaO = this.f_107230_;
        int offset = 1;
        float t = (float)(this.f_107224_ + offset) / (float)(this.f_107225_ + 1 + offset);
        this.m_107271_(0.6f * (1.0f - Mth.m_14207_((float)(2.0f * t - 1.0f))));
    }

    public float m_5902_(float partialTicks) {
        float t = ((float)this.f_107224_ + partialTicks) / (float)(this.f_107225_ + 1);
        return this.f_107663_ * (0.6f + (1.0f - Mth.m_14207_((float)(2.0f * t - 1.0f))) * 0.4f);
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Quaternionf quaternionf;
        Vec3 vec3 = pRenderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternionf = pRenderInfo.m_253121_();
        } else {
            quaternionf = new Quaternionf((Quaternionfc)pRenderInfo.m_253121_());
            quaternionf.rotateZ(Mth.m_14179_((float)pPartialTicks, (float)this.f_107204_, (float)this.f_107231_));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(pPartialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            float xWob = Mth.m_14179_((float)pPartialTicks, (float)this.xWobbleO, (float)this.xWobble);
            float yWob = Mth.m_14179_((float)pPartialTicks, (float)this.yWobbleO, (float)this.yWobble);
            vector3f.add(xWob, yWob, 0.0f);
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(size);
            vector3f.add(x, y, z);
        }
        float f6 = this.m_5970_();
        float f7 = this.m_5952_();
        float f4 = this.m_5951_();
        float f5 = this.m_5950_();
        float al = Mth.m_14179_((float)pPartialTicks, (float)this.alphaO, (float)this.f_107230_);
        int j = this.m_6355_(pPartialTicks);
        pBuffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, al).m_85969_(j).m_5752_();
        pBuffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f7, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, al).m_85969_(j).m_5752_();
        pBuffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f6, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, al).m_85969_(j).m_5752_();
        pBuffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f6, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, al).m_85969_(j).m_5752_();
    }

    public void m_5989_() {
        super.m_5989_();
        this.updateAlpha();
        float wobbleAmount = 0.12f;
        this.xWobbleO = this.xWobble;
        this.yWobbleO = this.yWobble;
        this.xWobble = this.f_107223_.m_188501_() * wobbleAmount;
        this.yWobble = this.f_107223_.m_188501_() * wobbleAmount;
    }

    public void m_6257_(double pX, double pY, double pZ) {
        Vec3 vec3;
        Vec3 moveDir;
        if (this.f_107219_ && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED && (moveDir = new Vec3(pX, pY, pZ)).m_82557_(vec3 = Entity.m_198894_(null, (Vec3)moveDir, (AABB)this.m_107277_(), (Level)this.f_107208_, List.of())) > 1.0E-9 && !(this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)).m_60734_() instanceof MagnetBlock)) {
            this.m_107274_();
            return;
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = pY != pY && pY < 0.0;
        if (pX != pX) {
            this.f_107215_ = 0.0;
        }
        if (pZ != pZ) {
            this.f_107217_ = 0.0;
        }
    }

    public ParticleRenderType m_7556_() {
        return MagnetParticleRenderType.ADDITIVE_TRANSLUCENCY;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            MagnetParticle particle = new MagnetParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            particle.m_108335_(this.sprite);
            if (MagnetsModule.greenMagnetParticles) {
                particle.m_107253_(200.0f, 50.0f, 120.0f);
            } else if (pType == MagnetsModule.attractorParticle) {
                particle.m_107253_(0.1f, 0.2f, 1.0f);
            } else {
                particle.m_107253_(1.0f, 0.1f, 0.2f);
            }
            return particle;
        }
    }
}

