/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import satisfyu.vinery.Vinery;
import satisfyu.vinery.effect.NormalEffect;
import satisfyu.vinery.effect.instant.CreeperEffect;
import satisfyu.vinery.effect.instant.TeleportEffect;
import satisfyu.vinery.effect.normal.ArmorEffect;
import satisfyu.vinery.effect.normal.ImprovedHealthEffect;
import satisfyu.vinery.effect.normal.LuckEffect;
import satisfyu.vinery.effect.normal.ResistanceEffect;
import satisfyu.vinery.effect.normal.TradingEffect;
import satisfyu.vinery.effect.normal.TrippyEffect;
import satisfyu.vinery.effect.ticking.ClimbingEffect;
import satisfyu.vinery.effect.ticking.FrostyArmorEffect;
import satisfyu.vinery.effect.ticking.JellieEffect;
import satisfyu.vinery.effect.ticking.LavaWalkerEffect;
import satisfyu.vinery.effect.ticking.MagnetEffect;
import satisfyu.vinery.effect.ticking.StaggerEffect;
import satisfyu.vinery.effect.ticking.WaterWalkerEffect;
import satisfyu.vinery.util.VineryIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> TRIPPY;
    public static final RegistrySupplier<MobEffect> JELLIE;
    public static final RegistrySupplier<MobEffect> MAGNET;
    public static final RegistrySupplier<MobEffect> TELEPORT;
    public static final RegistrySupplier<MobEffect> IMPROVED_JUMP_BOOST;
    public static final RegistrySupplier<MobEffect> WATER_WALKER;
    public static final RegistrySupplier<MobEffect> CREEPER_EFFECT;
    public static final RegistrySupplier<MobEffect> EXPERIENCE_EFFECT;
    public static final RegistrySupplier<MobEffect> LAVA_WALKER;
    public static final RegistrySupplier<MobEffect> STAGGER_EFFECT;
    public static final RegistrySupplier<MobEffect> FROSTY_ARMOR_EFFECT;
    public static final RegistrySupplier<MobEffect> PARTY_EFFECT;
    public static final RegistrySupplier<MobEffect> CLIMBING_EFFECT;
    public static final RegistrySupplier<MobEffect> LUCK_EFFECT;
    public static final RegistrySupplier<MobEffect> HEALTH_EFFECT;
    public static final RegistrySupplier<MobEffect> RESISTANCE_EFFECT;
    public static final RegistrySupplier<MobEffect> ARMOR_EFFECT;
    public static final RegistrySupplier<MobEffect> TRADING_EFFECT;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new VineryIdentifier(name), effect);
    }

    public static void init() {
        Vinery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        ARMOR_EFFECT = MobEffectRegistry.registerEffect("armor_effect", ArmorEffect::new);
        HEALTH_EFFECT = MobEffectRegistry.registerEffect("health_effect", ImprovedHealthEffect::new);
        LUCK_EFFECT = MobEffectRegistry.registerEffect("luck_effect", LuckEffect::new);
        RESISTANCE_EFFECT = MobEffectRegistry.registerEffect("resistance_effect", ResistanceEffect::new);
        TRIPPY = MobEffectRegistry.registerEffect("trippy", TrippyEffect::new);
        TRADING_EFFECT = MobEffectRegistry.registerEffect("trading", () -> new TradingEffect(MobEffectCategory.BENEFICIAL, 0xFF0000));
        EXPERIENCE_EFFECT = MobEffectRegistry.registerEffect("experience_effect", () -> new NormalEffect(MobEffectCategory.BENEFICIAL, 65280));
        IMPROVED_JUMP_BOOST = MobEffectRegistry.registerEffect("double_jump", () -> new NormalEffect(MobEffectCategory.BENEFICIAL, 9500817));
        PARTY_EFFECT = MobEffectRegistry.registerEffect("party_effect", () -> new NormalEffect(MobEffectCategory.BENEFICIAL, 0xFF0000));
        TELEPORT = MobEffectRegistry.registerEffect("teleport", TeleportEffect::new);
        CREEPER_EFFECT = MobEffectRegistry.registerEffect("creeper_effect", CreeperEffect::new);
        CLIMBING_EFFECT = MobEffectRegistry.registerEffect("climbing_effect", ClimbingEffect::new);
        FROSTY_ARMOR_EFFECT = MobEffectRegistry.registerEffect("frosty_armor", FrostyArmorEffect::new);
        JELLIE = MobEffectRegistry.registerEffect("jellie", JellieEffect::new);
        LAVA_WALKER = MobEffectRegistry.registerEffect("lava_walker", LavaWalkerEffect::new);
        MAGNET = MobEffectRegistry.registerEffect("magnet", MagnetEffect::new);
        STAGGER_EFFECT = MobEffectRegistry.registerEffect("staggering", StaggerEffect::new);
        WATER_WALKER = MobEffectRegistry.registerEffect("water_walker", WaterWalkerEffect::new);
    }
}

