/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.registry;

import de.cristelknight.doapi.client.render.feature.CustomArmorManager;
import de.cristelknight.doapi.client.render.feature.CustomArmorSet;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import satisfyu.vinery.client.VineryClient;
import satisfyu.vinery.client.model.StrawHatModel;
import satisfyu.vinery.client.model.WinemakerInner;
import satisfyu.vinery.client.model.WinemakerOuter;
import satisfyu.vinery.config.VineryConfig;
import satisfyu.vinery.item.WinemakerBoots;
import satisfyu.vinery.item.WinemakerChest;
import satisfyu.vinery.item.WinemakerHatItem;
import satisfyu.vinery.item.WinemakerLegs;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.util.VineryIdentifier;

public class ArmorRegistry {
    public static void registerArmorModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)StrawHatModel.LAYER_LOCATION, StrawHatModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)WinemakerInner.LAYER_LOCATION, WinemakerInner::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WinemakerOuter.LAYER_LOCATION, WinemakerOuter::createBodyLayer);
    }

    public static <T extends LivingEntity> void registerArmorModels(CustomArmorManager<T> armors, EntityModelSet modelLoader) {
        armors.addArmor(new CustomArmorSet(new Item[]{(Item)ObjectRegistry.STRAW_HAT.get(), (Item)ObjectRegistry.WINEMAKER_APRON.get(), (Item)ObjectRegistry.WINEMAKER_LEGGINGS.get(), (Item)ObjectRegistry.WINEMAKER_BOOTS.get()}).setTexture((ResourceLocation)new VineryIdentifier("winemaker")).setOuterModel(new WinemakerOuter(modelLoader.m_171103_(WinemakerOuter.LAYER_LOCATION))).setInnerModel(new WinemakerInner(modelLoader.m_171103_(WinemakerInner.LAYER_LOCATION))).setHatModel(new StrawHatModel(modelLoader.m_171103_(StrawHatModel.LAYER_LOCATION))));
    }

    public static <T extends LivingEntity> void registerHatModels(Map<Item, EntityModel<T>> models, EntityModelSet modelLoader) {
        models.put((Item)ObjectRegistry.STRAW_HAT.get(), new StrawHatModel(modelLoader.m_171103_(StrawHatModel.LAYER_LOCATION)));
    }

    public static void appendtooltip(List<Component> tooltip) {
        if (!((VineryConfig)VineryConfig.DEFAULT.getConfig()).enableWineMakerSetBonus()) {
            return;
        }
        Player player = VineryClient.getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        boolean helmetB = helmet.m_41720_() instanceof WinemakerHatItem;
        boolean chestplateB = chestplate.m_41720_() instanceof WinemakerChest;
        boolean leggingsB = leggings.m_41720_() instanceof WinemakerLegs;
        boolean bootsB = boots.m_41720_() instanceof WinemakerBoots;
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(ChatFormatting.AQUA + I18n.m_118938_((String)"tooltip.vinery.winemaker_armor", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmetB ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.STRAW_HAT.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((chestplateB ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_APRON.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((leggingsB ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_LEGGINGS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)((bootsB ? ChatFormatting.GREEN.toString() : ChatFormatting.GRAY.toString()) + "- [" + ((Item)ObjectRegistry.WINEMAKER_BOOTS.get()).m_41466_().getString() + "]")));
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add(Component.m_130674_((String)(ChatFormatting.GRAY + I18n.m_118938_((String)"tooltip.vinery.winemaker_armor2", (Object[])new Object[0]))));
        tooltip.add(Component.m_130674_((String)((helmetB && chestplateB && leggingsB && bootsB ? ChatFormatting.DARK_GREEN.toString() : ChatFormatting.GRAY.toString()) + I18n.m_118938_((String)"tooltip.vinery.winemaker_armor3", (Object[])new Object[0]))));
    }
}

