/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.client.gui.config;

import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.config.cloth.CCUtil;
import de.cristelknight.doapi.config.cloth.LinkEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import satisfyu.vinery.config.VineryConfig;

public class ClothConfigScreen {
    private static Screen lastScreen;

    public static Screen create(Screen parent) {
        lastScreen = parent;
        VineryConfig config = (VineryConfig)VineryConfig.DEFAULT.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setDefaultBackgroundTexture(new ResourceLocation("textures/block/dirt.png")).setTitle((Component)Component.m_237115_((String)"vinery.config.title").m_130940_(ChatFormatting.BOLD));
        ConfigEntries entries = new ConfigEntries(builder.entryBuilder(), config, builder.getOrCreateCategory(CCUtil.categoryName((String)"main", (String)"vinery")));
        builder.setSavingRunnable(() -> {
            VineryConfig.DEFAULT.setInstance(entries.createConfig());
            VineryConfig.DEFAULT.getConfig(true, true);
        });
        return builder.build();
    }

    public static void linkButtons(String MOD_ID, ConfigCategory category, ConfigEntryBuilder builder, String dcLink, String cfLink, Screen lastScreen) {
        if (lastScreen == null) {
            lastScreen = Minecraft.m_91087_().f_91080_;
        }
        TextListEntry tle = builder.startTextDescription((Component)Component.m_237113_((String)" ")).build();
        category.addEntry((AbstractConfigListEntry)tle);
        Screen finalLastScreen = lastScreen;
        category.addEntry((AbstractConfigListEntry)new LinkEntry(CCUtil.entryName((String)MOD_ID, (String)"dc"), buttonWidget -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(dcLink);
            }
            Minecraft.m_91087_().m_91152_(ClothConfigScreen.create(finalLastScreen));
        }, dcLink, true)), (ResourceLocation)new DoApiRL("textures/gui/dc.png"), 3));
        category.addEntry((AbstractConfigListEntry)tle);
        category.addEntry((AbstractConfigListEntry)new LinkEntry(CCUtil.entryName((String)MOD_ID, (String)"h"), buttonWidget -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(cfLink);
            }
            Minecraft.m_91087_().m_91152_(ClothConfigScreen.create(finalLastScreen));
        }, cfLink, true)), (ResourceLocation)new DoApiRL("textures/gui/cf.png"), 10));
    }

    private static class ConfigEntries {
        private final ConfigEntryBuilder builder;
        private final ConfigCategory category;
        private final BooleanListEntry enableWineMakerSetBonus;
        private final IntegerListEntry wineTraderChance;
        private final IntegerListEntry yearLengthInDays;
        private final IntegerListEntry yearsPerEffectLevel;
        private final IntegerListEntry fermentationBarrelTime;
        private final IntegerListEntry damagePerUse;
        private final IntegerListEntry probabilityForDamage;
        private final IntegerListEntry probabilityToKeepBoneMeal;
        private final IntegerListEntry grapeGrowthSpeed;
        private final BooleanListEntry entityInsideEnabled;

        public ConfigEntries(ConfigEntryBuilder builder, VineryConfig config, ConfigCategory category) {
            this.builder = builder;
            this.category = category;
            this.wineTraderChance = this.createIntField("wineTraderChance", config.wineTraderChance(), VineryConfig.DEFAULT.wineTraderChance(), null, 0, 100);
            this.yearLengthInDays = this.createIntField("yearLengthInDays", config.yearLengthInDays(), VineryConfig.DEFAULT.yearLengthInDays(), null, 1, 1000);
            this.yearsPerEffectLevel = this.createIntField("yearsPerEffectLevel", config.yearsPerEffectLevel(), VineryConfig.DEFAULT.yearsPerEffectLevel(), null, 1, 1000);
            this.fermentationBarrelTime = this.createIntField("fermentationBarrelTime", config.fermentationBarrelTime(), VineryConfig.DEFAULT.fermentationBarrelTime(), null, 1, 10000);
            this.grapeGrowthSpeed = this.createIntField("grapeGrowthSpeed", config.grapeGrowthSpeed(), VineryConfig.DEFAULT.grapeGrowthSpeed(), null, 1, 100);
            SubCategoryBuilder wineMaker = new SubCategoryBuilder((Component)Component.m_237119_(), (Component)Component.m_237115_((String)"config.vinery.subCategory.wineMaker"));
            this.enableWineMakerSetBonus = this.createBooleanField("enableWineMakerSetBonus", config.enableWineMakerSetBonus(), VineryConfig.DEFAULT.enableWineMakerSetBonus(), wineMaker);
            this.probabilityToKeepBoneMeal = this.createIntField("probabilityToKeepBoneMeal", config.probabilityToKeepBoneMeal(), VineryConfig.DEFAULT.probabilityToKeepBoneMeal(), wineMaker, 1, 100);
            this.probabilityForDamage = this.createIntField("probabilityForDamage", config.probabilityForDamage(), VineryConfig.DEFAULT.probabilityForDamage(), wineMaker, 0, 100);
            this.damagePerUse = this.createIntField("damagePerUse", config.damagePerUse(), VineryConfig.DEFAULT.damagePerUse(), wineMaker, 1, 1000);
            this.entityInsideEnabled = this.createBooleanField("entityInsideEnabled", config.entityInsideEnabled(), VineryConfig.DEFAULT.entityInsideEnabled(), null);
            category.addEntry((AbstractConfigListEntry)wineMaker.build());
            ClothConfigScreen.linkButtons("vinery", category, builder, "https://discord.gg/Vqu6wYZwdZ", "https://www.curseforge.com/minecraft/mc-mods/lets-do-wine", lastScreen);
        }

        public VineryConfig createConfig() {
            return new VineryConfig(this.wineTraderChance.getValue(), this.yearLengthInDays.getValue(), this.yearsPerEffectLevel.getValue(), this.enableWineMakerSetBonus.getValue(), this.damagePerUse.getValue(), this.probabilityForDamage.getValue(), this.probabilityToKeepBoneMeal.getValue(), this.fermentationBarrelTime.getValue(), this.grapeGrowthSpeed.getValue(), this.entityInsideEnabled.getValue());
        }

        public BooleanListEntry createBooleanField(String id, boolean value, boolean defaultValue, SubCategoryBuilder subCategoryBuilder) {
            BooleanListEntry e = CCUtil.createBooleanField((String)"vinery", (String)id, (boolean)value, (boolean)defaultValue, (ConfigEntryBuilder)this.builder);
            if (subCategoryBuilder == null) {
                this.category.addEntry((AbstractConfigListEntry)e);
            } else {
                subCategoryBuilder.add((AbstractConfigListEntry)e);
            }
            return e;
        }

        public IntegerListEntry createIntField(String id, int value, int defaultValue, SubCategoryBuilder subCategoryBuilder, int min, int max) {
            IntegerListEntry e = CCUtil.createIntField((String)"vinery", (String)id, (int)value, (int)defaultValue, (ConfigEntryBuilder)this.builder).setMaximum(max).setMinimum(min);
            if (subCategoryBuilder == null) {
                this.category.addEntry((AbstractConfigListEntry)e);
            } else {
                subCategoryBuilder.add((AbstractConfigListEntry)e);
            }
            return e;
        }
    }
}

