/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.storage;

import de.cristelknight.doapi.common.block.StorageBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import satisfyu.vinery.item.DrinkBlockSmallItem;
import satisfyu.vinery.registry.StorageTypeRegistry;

public class WineBox
extends StorageBlock {
    private static final VoxelShape SHAPE_S = WineBox.makeShapeS();
    private static final VoxelShape SHAPE_E = WineBox.makeShapeE();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;

    public WineBox(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST, Direction.EAST -> SHAPE_E;
            default -> SHAPE_S;
        };
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && stack.m_41619_()) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)OPEN) == false)), 3);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_41720_() instanceof DrinkBlockSmallItem;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};
    }

    public int size() {
        return 1;
    }

    public ResourceLocation type() {
        return StorageTypeRegistry.WINE_BOX;
    }

    public int getSection(Float x, Float y) {
        return 0;
    }

    private static VoxelShape makeShapeS() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.3125, (double)0.09375, (double)0.3125, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.3125, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.0, (double)0.3125, (double)0.90625, (double)0.3125, (double)0.34375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.03125, (double)0.34375, (double)0.90625, (double)0.09375, (double)0.65625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.0, (double)0.65625, (double)0.90625, (double)0.3125, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeShapeE() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.0625, (double)0.6875, (double)0.3125, (double)0.09375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.90625, (double)0.6875, (double)0.3125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.65625, (double)0.0, (double)0.09375, (double)0.6875, (double)0.3125, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.34375, (double)0.03125, (double)0.09375, (double)0.65625, (double)0.09375, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.09375, (double)0.34375, (double)0.3125, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }
}

