/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.stem;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.block.grape.GrapeType;
import satisfyu.vinery.block.stem.StemBlock;
import satisfyu.vinery.config.VineryConfig;
import satisfyu.vinery.item.GrapeBushSeedItem;
import satisfyu.vinery.registry.GrapeTypeRegistry;

public class PaleStemBlock
extends StemBlock {
    private static final VoxelShape PALE_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public PaleStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)GRAPE, (Comparable)GrapeTypeRegistry.NONE)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return PALE_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level world = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        if (blockState.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) {
            return blockState;
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (itemStack != null && (player.m_7500_() || itemStack.m_41613_() >= 2) && level.m_8055_(blockPos.m_7495_()).m_60734_() != this && blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_247087_()) {
                level.m_7731_(blockPos.m_7494_(), this.m_49966_(), 3);
                itemStack.m_41774_(1);
            }
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age > 0 && player.m_21120_(hand).m_41720_() == Items.f_42574_) {
            if (age > 2) {
                this.dropGrapes(world, state, pos, hit.m_82434_());
            }
            this.dropGrapeSeeds(world, state, pos, hit.m_82434_());
            world.m_7731_(pos, this.withAge(state, 0, GrapeTypeRegistry.NONE), 3);
            world.m_5594_(player, pos, SoundEvents.f_12455_, SoundSource.AMBIENT, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof GrapeBushSeedItem) {
            GrapeBushSeedItem seed = (GrapeBushSeedItem)item;
            if (this.hasTrunk(world, pos) && age == 0 && !seed.getType().isLattice()) {
                world.m_7731_(pos, this.withAge(state, 1, seed.getType()), 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                world.m_5594_(player, pos, SoundEvents.f_12456_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            if ((Integer)state.m_61143_((Property)AGE) > 0) {
                this.dropGrapeSeeds((Level)world, state, pos, null);
            }
            if ((Integer)state.m_61143_((Property)AGE) > 2) {
                this.dropGrapes((Level)world, state, pos, null);
            }
            world.m_46961_(pos, true);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        Random rand = new Random();
        if (rand.nextInt(100) + 1 > ((VineryConfig)VineryConfig.DEFAULT.getConfig()).grapeGrowthSpeed()) {
            return;
        }
        if (!this.isMature(state) && this.hasTrunk((Level)world, pos) && (Integer)state.m_61143_((Property)AGE) > 0 && world.m_45524_(pos, 0) >= 9 && (i = ((Integer)state.m_61143_((Property)AGE)).intValue()) < 4) {
            world.m_7731_(pos, this.withAge(state, i + 1, (GrapeType)state.m_61143_((Property)GRAPE)), 2);
        }
        super.m_213898_(state, world, pos, random);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60796_((BlockGetter)world, pos) || world.m_8055_(pos.m_7495_()).m_60734_() == this;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }
}

