/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.entity;

import de.cristelknight.doapi.common.world.ImplementedInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.client.gui.handler.ApplePressGuiHandler;
import satisfyu.vinery.recipe.ApplePressRecipe;
import satisfyu.vinery.registry.BlockEntityTypeRegistry;
import satisfyu.vinery.registry.RecipeTypesRegistry;

public class ApplePressBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
BlockEntityTicker<ApplePressBlockEntity> {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private static final int[] SLOTS_FOR_REST = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ApplePressBlockEntity.this.progress;
                case 1 -> ApplePressBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ApplePressBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ApplePressBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public ApplePressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypeRegistry.APPLE_PRESS_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] m_7071_(Direction side) {
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_REST;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new ApplePressGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("apple_press.progress", this.progress);
    }

    public void m_142466_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.progress = nbt.m_128451_("apple_press.progress");
        super.m_142466_(nbt);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public void tick(Level world, BlockPos blockPos, BlockState state, ApplePressBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        Recipe r = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.APPLE_PRESS_RECIPE_TYPE.get(), (Container)this, world).orElse(null);
        if (!(r instanceof ApplePressRecipe)) {
            entity.resetProgress();
            ApplePressBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
            return;
        }
        ApplePressRecipe recipe = (ApplePressRecipe)r;
        if (ApplePressBlockEntity.hasRecipe(entity, recipe)) {
            ++entity.progress;
            ApplePressBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
            if (entity.progress >= entity.maxProgress) {
                ApplePressBlockEntity.craftItem(entity, recipe);
            }
        } else {
            entity.resetProgress();
            ApplePressBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static void craftItem(ApplePressBlockEntity entity, ApplePressRecipe recipe) {
        SimpleContainer inventory = new SimpleContainer(entity.m_6643_());
        for (int i = 0; i < entity.m_6643_(); ++i) {
            inventory.m_6836_(i, entity.m_8020_(i));
        }
        entity.m_7407_(0, 1);
        ItemStack stack = recipe.assemble();
        stack.m_41764_(entity.m_8020_(1).m_41613_() + 1);
        entity.m_6836_(1, stack);
        entity.resetProgress();
    }

    private static boolean hasRecipe(ApplePressBlockEntity entity, ApplePressRecipe recipe) {
        SimpleContainer inventory = new SimpleContainer(entity.m_6643_());
        for (int i = 0; i < entity.m_6643_(); ++i) {
            inventory.m_6836_(i, entity.m_8020_(i));
        }
        ItemStack result = recipe.getResultItem();
        boolean r2 = ApplePressBlockEntity.canInsertAmountIntoOutputSlot(inventory, result.m_41613_());
        boolean r3 = ApplePressBlockEntity.canInsertItemIntoOutputSlot(inventory, result.m_41720_());
        return r2 && r3;
    }

    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, Item output) {
        return inventory.m_8020_(1).m_41720_() == output || inventory.m_8020_(1).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory, int additionalAmount) {
        return inventory.m_8020_(1).m_41741_() >= inventory.m_8020_(1).m_41613_() + additionalAmount;
    }
}

