/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import satisfyu.vinery.registry.ObjectRegistry;

public class SpreadableGrassSlab
extends SlabBlock
implements BonemealableBlock {
    public static final BooleanProperty SNOWY = BlockStateProperties.f_61451_;
    public static final Block GRASS_BLOCK = Blocks.f_50440_;

    public static Block getDirtSlabBlock() {
        return (Block)ObjectRegistry.DIRT_SLAB.get();
    }

    public static Block getGrassSlabBlock() {
        return (Block)ObjectRegistry.GRASS_SLAB.get();
    }

    public SpreadableGrassSlab(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)f_56354_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canSurviveNew(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = world.m_8055_(blockPos);
        if (state.m_60734_().equals(SpreadableGrassSlab.getDirtSlabBlock()) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
            return (Boolean)state.m_61143_((Property)SlabBlock.f_56354_) == false;
        }
        if (blockState.m_60713_(Blocks.f_50125_) && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockState.m_60819_().m_76186_() == 8) {
            return false;
        }
        if (state.m_204336_(BlockTags.f_13032_) && blockState.m_204336_(BlockTags.f_13032_) && blockState.m_60815_()) {
            return false;
        }
        if (blockState.m_60734_() instanceof SlabBlock && blockState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP) {
            return true;
        }
        if (blockState.m_60734_() instanceof StairBlock && blockState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP) {
            return true;
        }
        int i = LightEngine.m_284282_((BlockGetter)world, (BlockState)GRASS_BLOCK.m_49966_(), (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.m_60739_((BlockGetter)world, blockPos));
        return i < world.m_7469_();
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        if (blockState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
            return false;
        }
        return levelReader.m_8055_(blockPos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        GrassBlock block = (GrassBlock)GRASS_BLOCK;
        block.m_214148_(world, random, pos, state);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!SpreadableGrassSlab.canSurviveNew(state, (LevelReader)world, pos)) {
            world.m_7731_(pos, SpreadableGrassSlab.getDirtSlabBlock().m_152465_(world.m_8055_(pos)), 2);
        } else if (world.m_46803_(pos.m_7494_()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                SpreadableGrassSlab.trySpread(world, blockPos);
            }
        }
    }

    public static void trySpread(ServerLevel world, BlockPos spreadPos) {
        BlockState newState = null;
        BlockState oldState = world.m_8055_(spreadPos);
        BlockState aboveState = world.m_8055_(spreadPos.m_7494_());
        if (oldState.m_60713_(Blocks.f_50493_)) {
            newState = (BlockState)GRASS_BLOCK.m_49966_().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(aboveState.m_60713_(Blocks.f_50125_)));
        } else if (oldState.m_60713_(SpreadableGrassSlab.getDirtSlabBlock())) {
            newState = (BlockState)SpreadableGrassSlab.getGrassSlabBlock().m_152465_(oldState).m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(aboveState.m_60713_(Blocks.f_50125_)));
        }
        if (newState != null && SpreadableGrassSlab.canSurviveNew(newState, (LevelReader)world, spreadPos) && !world.m_6425_(spreadPos.m_7494_()).m_205070_(FluidTags.f_13131_)) {
            world.m_46597_(spreadPos, newState);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SNOWY});
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)f_56354_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        state = (BlockState)state.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_144279_)));
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }
}

