/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import satisfyu.vinery.block.GrapeItem;
import satisfyu.vinery.block.grape.GrapeProperty;
import satisfyu.vinery.block.grape.GrapeType;
import satisfyu.vinery.registry.GrapeTypeRegistry;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.registry.SoundEventRegistry;

public class GrapevinePotBlock
extends Block {
    private static final VoxelShape FILLING_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)1.0), Block.m_49796_((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)0.0), Block.m_49796_((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)16.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0)});
    private static final VoxelShape SMASHING_SHAPE = Shapes.m_83110_((VoxelShape)FILLING_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0));
    private static final int MAX_STAGE = 6;
    private static final int MAX_STORAGE = 6;
    private static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)6);
    private static final IntegerProperty STORAGE = IntegerProperty.m_61631_((String)"storage", (int)0, (int)6);
    private static final int DECREMENT_PER_WINE_BOTTLE = 3;
    private static final GrapeProperty GRAPEVINE_TYPE = GrapeProperty.create("type");

    public GrapevinePotBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)STORAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)GRAPEVINE_TYPE, (Comparable)GrapeTypeRegistry.NONE));
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)STAGE) < 3) {
            return super.m_5939_(state, world, pos, context);
        }
        return SMASHING_SHAPE;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        int activeStage;
        super.m_142072_(world, state, pos, entity, fallDistance);
        if (entity instanceof LivingEntity && (activeStage = ((Integer)state.m_61143_((Property)STAGE)).intValue()) >= 3) {
            if (activeStage < 6) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(activeStage + 1)), 3);
            }
            world.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.BLOCK_GRAPEVINE_POT_SQUEEZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean canTakeWine(BlockState state, ItemStack stackInHand) {
        int storage = (Integer)state.m_61143_((Property)STORAGE);
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (this.canTakeWine(storage) && stage == 6) {
            return stackInHand.m_150930_(((Item)ObjectRegistry.WINE_BOTTLE.get()).m_5456_());
        }
        return false;
    }

    private boolean canTakeWine(int storage) {
        return switch (storage) {
            case 3, 6, 9 -> true;
            default -> false;
        };
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (((Integer)state.m_61143_((Property)STAGE) > 3 || (Integer)state.m_61143_((Property)STORAGE) >= 6) && stack.m_41720_() instanceof GrapeItem) {
            return InteractionResult.PASS;
        }
        Item item = stack.m_41720_();
        if (item instanceof GrapeItem) {
            BlockState newState;
            GrapeItem grape = (GrapeItem)item;
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            int stage = (Integer)state.m_61143_((Property)STAGE);
            int storage = (Integer)state.m_61143_((Property)STORAGE);
            boolean playSound = false;
            if (stage == 0) {
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)STORAGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)GRAPEVINE_TYPE, (Comparable)grape.getType()), 3);
                playSound = true;
            }
            if (!this.isFilled(state)) {
                newState = world.m_8055_(pos);
                world.m_7731_(pos, (BlockState)newState.m_61124_((Property)STORAGE, (Comparable)Integer.valueOf(storage + 1)), 3);
                playSound = true;
            }
            newState = world.m_8055_(pos);
            int newStage = (Integer)newState.m_61143_((Property)STAGE);
            int newStorage = (Integer)newState.m_61143_((Property)STORAGE);
            switch (newStorage) {
                case 3: 
                case 6: 
                case 9: {
                    if (newStage >= 3) break;
                    world.m_7731_(pos, (BlockState)newState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(newStage + 1)), 3);
                }
            }
            if (playSound) {
                world.m_5594_(player, pos, SoundEvents.f_11828_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(((Item)ObjectRegistry.WINE_BOTTLE.get()).m_5456_()) && this.canTakeWine(state, stack)) {
            ItemStack output = ((GrapeType)state.m_61143_((Property)GRAPEVINE_TYPE)).getBottle().m_7968_();
            int storage = (Integer)state.m_61143_((Property)STORAGE);
            int newStorage = storage - 3;
            if (newStorage == 0) {
                world.m_7731_(pos, (BlockState)((BlockState)world.m_8055_(pos).m_61124_((Property)STORAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)STORAGE, (Comparable)Integer.valueOf(newStorage)), 3);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!player.m_150109_().m_36054_(output)) {
                player.m_7197_(output, false, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isFilled(BlockState state) {
        return (Integer)state.m_61143_((Property)STORAGE) >= 6;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)0.625, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)0.625, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.625, (double)0.0625));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.625, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375));
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE, STORAGE, GRAPEVINE_TYPE});
    }
}

