/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeSphere
extends Shape {
    private String[] domeNames = new String[]{"-", "+X", "+Y", "+Z", "-X", "-Y", "-Z"};
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.radius"), () -> this.update());
    private PropertyEnum<dome> propertyDome = new PropertyEnum<dome>(dome.NO, BuildGuide.screenHandler.translate("property.buildguide.dome"), () -> this.update(), this.domeNames);
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapeSphere() {
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyDome);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float radius = ((Float)this.propertyRadius.value).floatValue();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        this.setOriginOffset(offset, offset, offset);
        int x = (int)Math.floor((this.propertyDome.value == dome.POSITIVE_X ? 0.5 : (double)(-radius)) + offset);
        while (true) {
            double d = x;
            double d2 = this.propertyDome.value == dome.NEGATIVE_X ? -0.5 : (double)radius;
            if (!(d <= Math.ceil(d2 + offset))) break;
            int y = (int)Math.floor((this.propertyDome.value == dome.POSITIVE_Y ? 0.5 : (double)(-radius)) + offset);
            while (true) {
                double d3 = y;
                double d4 = this.propertyDome.value == dome.NEGATIVE_Y ? -0.5 : (double)radius;
                if (!(d3 <= Math.ceil(d4 + offset))) break;
                int z = (int)Math.floor((this.propertyDome.value == dome.POSITIVE_Z ? 0.5 : (double)(-radius)) + offset);
                while (true) {
                    double d5 = z;
                    double d6 = this.propertyDome.value == dome.NEGATIVE_Z ? -0.5 : (double)radius;
                    if (!(d5 <= Math.ceil(d6 + offset))) break;
                    double r2 = ((double)x - offset) * ((double)x - offset) + ((double)y - offset) * ((double)y - offset) + ((double)z - offset) * ((double)z - offset);
                    if (r2 >= ((double)radius - 0.5) * ((double)radius - 0.5) && r2 <= ((double)radius + 0.5) * ((double)radius + 0.5)) {
                        this.addShapeCube(buffer, x, y, z);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.sphere";
    }

    private static enum dome {
        NO,
        POSITIVE_X,
        POSITIVE_Y,
        POSITIVE_Z,
        NEGATIVE_X,
        NEGATIVE_Y,
        NEGATIVE_Z;

    }
}

