/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyFloat;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeCone
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, BuildGuide.screenHandler.translate("property.buildguide.direction"), () -> this.update(), this.directionNames);
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.radius"), () -> this.update());
    private PropertyFloat propertyHeight = new PropertyFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.height"), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapeCone() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyHeight);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.setOriginOffset(0.0, offset, offset);
                break;
            }
            case Y: {
                this.setOriginOffset(offset, 0.0, offset);
                break;
            }
            case Z: {
                this.setOriginOffset(offset, offset, 0.0);
            }
        }
        float radius = ((Float)this.propertyRadius.value).floatValue();
        float height = ((Float)this.propertyHeight.value).floatValue();
        for (int x = (int)Math.floor((double)(-radius) + offset); x <= (int)Math.ceil((double)radius + offset); ++x) {
            for (int y = (int)Math.floor((double)(-radius) + offset); y <= (int)Math.ceil((double)radius + offset); ++y) {
                block12: for (int z = height < 0.0f ? (int)Math.floor(height) : 0; z <= (height > 0.0f ? (int)Math.ceil(height) : 0); ++z) {
                    double r = Math.sqrt(((double)x - offset) * ((double)x - offset) + ((double)y - offset) * ((double)y - offset));
                    if (!(r <= (double)radius + 0.5) || !((double)Math.abs(height) * (1.0 - r / (double)radius) >= (double)Math.abs(z) - 0.5 && (double)Math.abs(height) * (1.0 - r / (double)radius) < (double)Math.abs(z) + 0.5) && (!((double)Math.abs(height) * (1.0 - (r - 0.5) / (double)radius) >= (double)Math.abs(z)) || !((double)Math.abs(height) * (1.0 - (r + 0.5) / (double)radius) < (double)Math.abs(z)))) continue;
                    switch ((direction)((Object)this.propertyDir.value)) {
                        case X: {
                            this.addShapeCube(buffer, z, x, y);
                            continue block12;
                        }
                        case Y: {
                            this.addShapeCube(buffer, x, z, y);
                            continue block12;
                        }
                        case Z: {
                            this.addShapeCube(buffer, x, y, z);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.cone";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }
}

