/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.ItemsIndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.StatsSorting;
import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public abstract class IndexViewScreen
extends Screen {
    public static final ResourceLocation INDEX_LOCATION = CompletionistsIndex.id("textures/gui/index.png");
    private static final MutableComponent PREVIOUS_PAGE_COMPONENT = Component.m_237115_((String)"createWorld.customize.custom.prev");
    private static final MutableComponent NEXT_PAGE_COMPONENT = Component.m_237115_((String)"createWorld.customize.custom.next");
    protected final Screen lastScreen;
    protected int leftPos;
    protected int topPos;
    private Button turnPageBackwards;
    private Button turnPageForwards;
    private static StatsSorting statsSorting = StatsSorting.CREATIVE;
    private int currentPage;
    private Component leftPageIndicator;
    private Component rightPageIndicator;
    private List<IndexViewPage> pages;
    @Nullable
    private List<Component> tooltipLines;

    protected IndexViewScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"gui.stats"));
        this.lastScreen = lastScreen;
    }

    public Comparator<IndexViewPage.Entry> getComparator() {
        return statsSorting.getComparator();
    }

    protected abstract List<IndexViewPage.Entry> getPageEntries();

    protected void rebuildPages() {
        this.pages = IndexViewPage.createPages(this, this.getPageEntries());
        this.setCurrentPage(0);
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 316) / 2;
        this.topPos = (this.f_96544_ - 198) / 2;
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 17, this.topPos + 11, 16, 13, 42, 202, 20, INDEX_LOCATION, 512, 256, button -> this.m_7379_()))).m_257544_(Tooltip.m_257550_((Component)CommonComponents.f_130660_));
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 316 - 17 - 16, this.topPos + 11, 16, 13, 62, 202, 20, INDEX_LOCATION, 512, 256, button -> {
            statsSorting = statsSorting.cycle();
            button.m_257544_(Tooltip.m_257550_((Component)IndexViewScreen.statsSorting.component));
            this.rebuildPages();
        }))).m_257544_(Tooltip.m_257550_((Component)IndexViewScreen.statsSorting.component));
        this.turnPageBackwards = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 27, this.topPos + 173, 18, 10, 1, 203, 20, INDEX_LOCATION, 512, 256, button -> this.decrementPage()));
        this.turnPageBackwards.m_257544_(Tooltip.m_257550_((Component)PREVIOUS_PAGE_COMPONENT));
        this.turnPageForwards = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.leftPos + 316 - 27 - 18, this.topPos + 173, 18, 10, 21, 203, 20, INDEX_LOCATION, 512, 256, button -> this.incrementPage()));
        this.turnPageForwards.m_257544_(Tooltip.m_257550_((Component)NEXT_PAGE_COMPONENT));
        this.setCurrentPage(this.currentPage);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.tooltipLines = null;
        this.m_280273_(guiGraphics);
        this.m_7522_(null);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(INDEX_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, 316, 198, 512, 256);
        guiGraphics.m_280614_(this.f_96547_, this.leftPageIndicator, this.leftPos + 82 - this.f_96547_.m_92852_((FormattedText)this.leftPageIndicator) / 2, this.topPos + 13, 12100746, false);
        guiGraphics.m_280614_(this.f_96547_, this.rightPageIndicator, this.leftPos + 233 - this.f_96547_.m_92852_((FormattedText)this.rightPageIndicator) / 2, this.topPos + 13, 12100746, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, tickDelta);
        if (this.pages != null && !this.pages.isEmpty()) {
            this.pages.get(this.currentPage).m_88315_(guiGraphics, mouseX, mouseY, tickDelta);
        }
        if (this.tooltipLines != null) {
            guiGraphics.m_280677_(this.f_96547_, this.tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
        if (!super.m_6375_(mouseX, mouseY, buttonId) && this.pages != null && !this.pages.isEmpty()) {
            return this.pages.get(this.currentPage).mouseClicked((int)mouseX, (int)mouseY, buttonId);
        }
        return false;
    }

    private void decrementPage() {
        if (this.currentPage > 0) {
            this.setCurrentPage(this.currentPage - 1);
        }
    }

    private void incrementPage() {
        if (this.currentPage < this.getAllPages() - 1) {
            this.setCurrentPage(this.currentPage + 1);
        }
    }

    private void setCurrentPage(int newPage) {
        this.currentPage = newPage;
        this.turnPageForwards.f_93624_ = true;
        this.turnPageBackwards.f_93624_ = true;
        if (newPage == 0) {
            this.turnPageBackwards.f_93624_ = false;
        }
        if (newPage >= this.getAllPages() - 1) {
            this.turnPageForwards.f_93624_ = false;
        }
        this.leftPageIndicator = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 1, this.getAllPages() * 2});
        this.rightPageIndicator = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 2, this.getAllPages() * 2});
    }

    private int getAllPages() {
        return this.pages != null && !this.pages.isEmpty() ? this.pages.size() : 1;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.decrementPage();
            return true;
        }
        if (delta < 0.0) {
            this.incrementPage();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public static class IndexViewPage
    implements Renderable {
        private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("#.##");
        private final Entry[] entries = new Entry[14];
        private final IndexViewScreen screen;

        private IndexViewPage(IndexViewScreen screen) {
            this.screen = screen;
        }

        public static List<IndexViewPage> createPages(IndexViewScreen screen, List<Entry> entries) {
            ImmutableList.Builder builder = ImmutableList.builder();
            IndexViewPage page = null;
            int itemsCount = 0;
            for (Entry entry : entries) {
                if (page == null) {
                    page = new IndexViewPage(screen);
                    builder.add((Object)page);
                }
                page.entries[itemsCount] = entry;
                if (++itemsCount < 14) continue;
                itemsCount = 0;
                page = null;
            }
            return builder.build();
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderPageHalf(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 16, this.screen.topPos + 26, 0, 7);
            this.renderPageHalf(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 167, this.screen.topPos + 26, 7, 14);
        }

        private void renderPageHalf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int startX, int startY, int startIndex, int endIndex) {
            Entry entry;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)startX, (float)startY, 0.0f);
            for (int i = startIndex; i < endIndex && (entry = this.entries[i]) != null; ++i) {
                int mouseXOffset = mouseX - startX;
                int mouseYOffset = mouseY - startY - i % 7 * 21;
                Minecraft minecraft = ScreenHelper.INSTANCE.getMinecraft((Screen)this.screen);
                entry.render(minecraft, guiGraphics, mouseXOffset, mouseYOffset, partialTick);
                if (entry.tryRenderTooltip(guiGraphics, mouseXOffset, mouseYOffset)) {
                    this.screen.tooltipLines = entry.getTooltipLines();
                }
                guiGraphics.m_280168_().m_252880_(0.0f, 21.0f, 0.0f);
            }
            guiGraphics.m_280168_().m_85849_();
        }

        public boolean mouseClicked(int mouseX, int mouseY, int buttonId) {
            for (int i = 0; i < this.entries.length; ++i) {
                int startY;
                Entry entry = this.entries[i];
                if (entry == null) {
                    return false;
                }
                int startX = i >= 7 ? this.screen.leftPos + 167 : this.screen.leftPos + 16;
                if (!entry.isMouseOver(mouseX - startX, mouseY - (startY = this.screen.topPos + 26) - i % 7 * 21)) continue;
                return entry.mouseClicked(this.screen, mouseX, mouseY, buttonId);
            }
            return false;
        }

        public static Entry modItemEntry(String modId, List<ItemStack> items, StatsCounter statsCounter, Font font) {
            if (items.isEmpty()) {
                throw new IllegalArgumentException("items cannot be empty");
            }
            MutableComponent modName = modId.equals("__ALL__") ? Component.m_237115_((String)"gui.all") : Component.m_237113_((String)ModLoaderEnvironment.INSTANCE.getModName(modId).orElse(IndexViewPage.prettifyModId(modId)));
            ItemStack displayItem = (ItemStack)items.stream().skip((int)(Math.random() * (double)items.size())).findAny().orElseThrow();
            long collectedCount = items.stream().filter(stack -> {
                int crafted;
                int pickedUp = statsCounter.m_13017_(Stats.f_12984_, (Object)stack.m_41720_());
                return pickedUp + (crafted = statsCounter.m_13017_(Stats.f_12981_, (Object)stack.m_41720_())) > 0;
            }).count();
            boolean collected = collectedCount == (long)items.size();
            float collectionProgress = (float)collectedCount / (float)items.size();
            MutableComponent tooltipComponent = Component.m_237119_().m_7220_((Component)modName).m_7220_((Component)Component.m_237113_((String)(" (" + PERCENTAGE_FORMAT.format(collectionProgress * 100.0f) + "%)")).m_130940_(ChatFormatting.GOLD));
            return new ModItemEntry(displayItem, IndexViewPage.formatDisplayName(font, (Component)modName, collected), collected, List.of(tooltipComponent), (Component)Component.m_237113_((String)(collectedCount + "/" + items.size())), collectionProgress, items);
        }

        private static String prettifyModId(String modId) {
            String[] parts;
            StringJoiner joiner = new StringJoiner(" ");
            for (String part : parts = modId.split("_")) {
                if (part.isEmpty()) continue;
                joiner.add(Character.toUpperCase(part.charAt(0)) + part.substring(1).toLowerCase(Locale.ROOT));
            }
            return joiner.toString();
        }

        public static Entry statsItemEntry(ItemStack stack, StatsCounter statsCounter, Font font) {
            int pickedUp = statsCounter.m_13017_(Stats.f_12984_, (Object)stack.m_41720_());
            int crafted = statsCounter.m_13017_(Stats.f_12981_, (Object)stack.m_41720_());
            boolean collected = pickedUp > 0 || crafted > 0;
            Component displayName = stack.m_41720_().m_7626_(stack);
            FormattedText formattedName = IndexViewPage.formatDisplayName(font, displayName, collected);
            ArrayList lines = Lists.newArrayList();
            lines.add(Component.m_237119_().m_7220_(stack.m_41720_().m_7626_(stack)).m_130940_(stack.m_41791_().f_43022_));
            stack.m_41720_().m_7373_(stack, null, (List)lines, (TooltipFlag)TooltipFlag.f_256752_);
            if (pickedUp > 0) {
                lines.add(Component.m_237113_((String)String.valueOf(pickedUp)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"stat_type.minecraft.picked_up")).m_130940_(ChatFormatting.BLUE));
            }
            if (crafted > 0) {
                lines.add(Component.m_237113_((String)String.valueOf(crafted)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"stat_type.minecraft.crafted")).m_130940_(ChatFormatting.BLUE));
            }
            return new StatsItemEntry(stack, formattedName, collected, (List<Component>)ImmutableList.copyOf((Collection)lines));
        }

        private static FormattedText formatDisplayName(Font font, Component displayName, boolean collected) {
            Style style = Style.f_131099_.m_178520_(collected ? 4957487 : ChatFormatting.BLACK.m_126665_());
            Object formattedText = font.m_92852_((FormattedText)displayName) > 95 ? FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92865_().m_92389_((FormattedText)displayName, 95 - font.m_92895_("..."), style), Component.m_237113_((String)"...").m_130948_(style)}) : Component.m_237119_().m_7220_(displayName).m_130948_(style);
            return formattedText;
        }

        public static abstract class Entry {
            final ItemStack item;
            final FormattedText displayName;
            private final boolean collected;
            private final List<Component> tooltipLines;

            private Entry(ItemStack item, FormattedText displayName, boolean collected, List<Component> tooltipLines) {
                this.item = item;
                this.displayName = displayName;
                this.collected = collected;
                this.tooltipLines = tooltipLines;
            }

            public abstract <T extends Comparable<? super T>> T toComparableKey();

            public boolean isCollected() {
                return this.collected;
            }

            List<Component> getTooltipLines() {
                return this.tooltipLines;
            }

            public void render(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
                this.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean tryRenderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
                if (this.isHovering(0, 0, 18, 18, mouseX, mouseY)) {
                    AbstractContainerScreen.m_280359_((GuiGraphics)guiGraphics, (int)1, (int)1, (int)0);
                    return true;
                }
                return false;
            }

            public boolean isMouseOver(int mouseX, int mouseY) {
                return this.isHovering(0, 0, 134, 18, mouseX, mouseY);
            }

            public boolean mouseClicked(IndexViewScreen screen, int mouseX, int mouseY, int buttonId) {
                return false;
            }

            private boolean isHovering(int minX, int minY, int maxX, int maxY, int mouseX, int mouseY) {
                return mouseX > minX && mouseX <= maxX && mouseY > minY && mouseY <= maxY;
            }

            public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(INDEX_LOCATION, 0, 0, 120.0f, 208.0f, 18, 18, 512, 256);
                guiGraphics.m_280163_(INDEX_LOCATION, 124, 4, (float)(120 + (this.collected ? 10 : 0)), 198.0f, 10, 10, 512, 256);
            }

            public void renderForeground(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280480_(this.item, 1, 1);
            }
        }

        public static class ModItemEntry
        extends Entry {
            private final Component collection;
            private final float collectionProgress;
            private final List<ItemStack> items;

            public ModItemEntry(ItemStack item, FormattedText displayName, boolean collected, List<Component> tooltipLines, Component collection, float collectionProgress, List<ItemStack> items) {
                super(item, displayName, collected, tooltipLines);
                this.collection = collection;
                this.collectionProgress = collectionProgress;
                this.items = items;
            }

            @Override
            public <T extends Comparable<? super T>> T toComparableKey() {
                return (T)this.displayName.getString();
            }

            @Override
            public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(INDEX_LOCATION, 24, 11, 140.0f, 198.0f, 91, 5, 512, 256);
                guiGraphics.m_280163_(INDEX_LOCATION, 24, 11, 140.0f, 203.0f, (int)(91.0f * this.collectionProgress), 5, 512, 256);
                if (this.isMouseOver(mouseX, mouseY)) {
                    guiGraphics.m_280163_(INDEX_LOCATION, -2, -2, 316.0f, 0.0f, 140, 22, 512, 256);
                }
            }

            @Override
            public void renderForeground(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick);
                Font font = minecraft.f_91062_;
                int posX = 70 - font.m_92852_(this.displayName) / 2;
                guiGraphics.m_280649_(font, Language.m_128107_().m_5536_(this.displayName), posX, 0, 0, false);
                posX = 70 - font.m_92852_((FormattedText)this.collection) / 2;
                guiGraphics.m_280614_(font, this.collection, posX - 1, 10, 0, false);
                guiGraphics.m_280614_(font, this.collection, posX, 9, 0, false);
                guiGraphics.m_280614_(font, this.collection, posX, 11, 0, false);
                guiGraphics.m_280614_(font, this.collection, posX + 1, 10, 0, false);
                guiGraphics.m_280614_(font, this.collection, posX, 10, 16762624, false);
            }

            @Override
            public boolean mouseClicked(IndexViewScreen screen, int mouseX, int mouseY, int buttonId) {
                Minecraft minecraft = ScreenHelper.INSTANCE.getMinecraft((Screen)screen);
                minecraft.m_91152_((Screen)new ItemsIndexViewScreen(screen, this.items));
                minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        }

        private static class StatsItemEntry
        extends Entry {
            public StatsItemEntry(ItemStack item, FormattedText displayName, boolean collected, List<Component> tooltipLines) {
                super(item, displayName, collected, tooltipLines);
            }

            @Override
            public <T extends Comparable<? super T>> T toComparableKey() {
                return (T)BuiltInRegistries.f_257033_.m_7981_((Object)this.item.m_41720_()).m_135815_();
            }

            @Override
            public void renderForeground(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick);
                guiGraphics.m_280649_(minecraft.f_91062_, Language.m_128107_().m_5536_(this.displayName), 23, 5, 0, false);
            }
        }
    }
}

