/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.PlanetHandler;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.tags.ModEntityTypeTags;
import java.util.Collection;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class OxygenApiImpl
implements OxygenApi {
    @Override
    public boolean hasOxygen(Level level) {
        return this.hasOxygen((ResourceKey<Level>)level.m_46472_());
    }

    @Override
    public boolean hasOxygen(ResourceKey<Level> level) {
        return (Boolean)Optionull.m_269278_((Object)PlanetApi.API.getPlanet(level), Planet::oxygen, (Object)true);
    }

    @Override
    public boolean hasOxygen(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return this.hasOxygen(level);
        }
        return PlanetHandler.hasOxygen((ServerLevel)level, pos);
    }

    @Override
    public boolean hasOxygen(Entity entity) {
        boolean hasOxygen = this.hasOxygen(entity.m_9236_(), BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_()));
        return AdAstraEvents.EntityOxygenEvent.fire(entity, hasOxygen);
    }

    @Override
    public void setOxygen(Level level, BlockPos pos, boolean oxygen) {
        if (level.m_5776_()) {
            return;
        }
        PlanetHandler.setOxygen((ServerLevel)level, pos, oxygen);
    }

    @Override
    public void setOxygen(Level level, Collection<BlockPos> positions, boolean oxygen) {
        if (level.m_5776_()) {
            return;
        }
        PlanetHandler.setOxygen((ServerLevel)level, positions, oxygen);
    }

    @Override
    public void removeOxygen(Level level, BlockPos pos) {
        this.setOxygen(level, pos, this.hasOxygen(level));
    }

    @Override
    public void removeOxygen(Level level, Collection<BlockPos> positions) {
        this.setOxygen(level, positions, this.hasOxygen(level));
    }

    @Override
    public void entityTick(ServerLevel level, LivingEntity entity) {
        if (AdAstraConfig.disableOxygen) {
            return;
        }
        if (entity.m_6095_().m_204039_(ModEntityTypeTags.LIVES_WITHOUT_OXYGEN)) {
            return;
        }
        if (entity.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_IN_SPACE)) {
            return;
        }
        if (SpaceSuitItem.hasFullSet(entity) && SpaceSuitItem.hasOxygen((Entity)entity)) {
            return;
        }
        if (this.hasOxygen((Entity)entity)) {
            return;
        }
        entity.m_6469_(ModDamageSources.create((Level)level, ModDamageSources.OXYGEN), 2.0f);
        entity.m_20301_(-80);
    }
}

