/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.armor;

import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.KeybindManager;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedItemEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetSuitItem
extends SpaceSuitItem
implements BotariumEnergyItem<WrappedItemEnergyContainer> {
    private final long energyCapacity;

    public JetSuitItem(ArmorMaterial material, ArmorItem.Type type, int tankSize, int energy, Item.Properties properties) {
        super(material, type, tankSize, properties);
        this.energyCapacity = energy;
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidConstants.fromMillibuckets((long)this.tankSize), (Fluid)ModFluids.OXYGEN.get()));
        WrappedItemEnergyContainer energy = this.getEnergyStorage(stack);
        tooltipComponents.add(TooltipUtils.getEnergyComponent(energy.getStoredEnergy(), this.energyCapacity));
        tooltipComponents.add(TooltipUtils.getMaxEnergyInComponent(energy.maxInsert()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.JET_SUIT_INFO);
    }

    public WrappedItemEnergyContainer getEnergyStorage(ItemStack holder) {
        return new WrappedItemEnergyContainer(holder, (EnergyContainer)new SimpleEnergyContainer(this.energyCapacity){

            public long maxInsert() {
                return 1000L;
            }
        });
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_6844_(EquipmentSlot.CHEST) != stack) {
            return;
        }
        if (player.m_150110_().f_35935_) {
            return;
        }
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        if (!JetSuitItem.hasFullJetSuitSet((LivingEntity)player)) {
            return;
        }
        if (!KeybindManager.suitFlightEnabled(player)) {
            return;
        }
        if (!KeybindManager.jumpDown(player)) {
            return;
        }
        if (!this.canFly(player, stack)) {
            return;
        }
        if (KeybindManager.sprintDown(player)) {
            this.fullFlight(player);
            this.consume(player, stack, 100);
        } else {
            this.upwardsFlight(player);
            this.consume(player, stack, 50);
        }
    }

    protected void upwardsFlight(Player player) {
        double acceleration = JetSuitItem.sigmoidAcceleration(player.f_19797_, 5.0, 1.0, 2.0);
        player.m_246865_(new Vec3(0.0, Math.max(0.0025, acceleration /= 25.0), 0.0));
        player.f_19789_ = Math.max(player.f_19789_ / 1.5f, 0.0f);
    }

    protected void fullFlight(Player player) {
        Vec3 movement = player.m_20154_().m_82541_().m_82490_(0.075);
        if (player.m_20184_().m_82553_() > 2.0) {
            return;
        }
        player.m_246865_(movement);
        player.f_19789_ = Math.max(player.f_19789_ / 1.5f, 0.0f);
        if (!player.m_21255_()) {
            player.m_36320_();
        }
    }

    private boolean canFly(Player player, ItemStack stack) {
        return player.m_7500_() || this.getEnergyStorage(stack).getStoredEnergy() > 0L;
    }

    private void consume(Player player, ItemStack stack, int amount) {
        if (player.m_7500_() || player.m_5833_() || player.m_9236_().m_5776_()) {
            return;
        }
        this.getEnergyStorage(stack).internalExtract((long)amount, false);
    }

    protected boolean isFullFlightEnabled(Player player) {
        return KeybindManager.suitFlightEnabled(player) && KeybindManager.jumpDown(player) && KeybindManager.sprintDown(player);
    }

    public static double sigmoidAcceleration(double t, double peakTime, double peakAcceleration, double initialAcceleration) {
        return 2.0 * peakAcceleration / (1.0 + Math.exp(-t / peakTime)) - peakAcceleration + initialAcceleration;
    }

    public void spawnParticles(Level level, LivingEntity entity, HumanoidModel<?> model, ItemStack stack) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.canFly(player, stack)) {
            return;
        }
        if (!JetSuitItem.hasFullJetSuitSet((LivingEntity)player)) {
            return;
        }
        if (!KeybindManager.suitFlightEnabled(player)) {
            return;
        }
        if (!KeybindManager.jumpDown(player) || !KeybindManager.jumpDown(player) && !KeybindManager.sprintDown(player)) {
            return;
        }
        this.spawnParticles(level, entity, (double)model.f_102811_.f_104203_ + 0.05, entity.m_21255_() ? 0.0 : 0.8, -0.45);
        this.spawnParticles(level, entity, (double)model.f_102812_.f_104203_ + 0.05, entity.m_21255_() ? 0.0 : 0.8, 0.45);
        this.spawnParticles(level, entity, (double)model.f_102813_.f_104203_ + 0.05, entity.m_21255_() ? 0.1 : 0.0, -0.1);
        this.spawnParticles(level, entity, (double)model.f_102814_.f_104203_ + 0.05, entity.m_21255_() ? 0.1 : 0.0, 0.1);
    }

    private void spawnParticles(Level level, LivingEntity entity, double pitch, double yOffset, double zOffset) {
        double yRot = entity.f_20883_;
        double forwardOffsetX = Math.cos(yRot * Math.PI / 180.0) * zOffset;
        double forwardOffsetZ = Math.sin(yRot * Math.PI / 180.0) * zOffset;
        double sideOffsetX = Math.cos((yRot - 90.0) * Math.PI / 180.0) * pitch;
        double sideOffsetZ = Math.sin((yRot - 90.0) * Math.PI / 180.0) * pitch;
        level.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, entity.m_20185_() + forwardOffsetX + sideOffsetX, entity.m_20186_() + yOffset, entity.m_20189_() + sideOffsetZ + forwardOffsetZ, 0.0, 0.0, 0.0);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (entity.m_9236_().m_5776_()) {
            return true;
        }
        if (this.f_265916_ != ArmorItem.Type.CHESTPLATE) {
            return true;
        }
        int nextFlightTick = flightTicks + 1;
        if (nextFlightTick % 10 != 0) {
            return true;
        }
        if (nextFlightTick % 20 == 0) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
        }
        entity.m_146850_(GameEvent.f_223705_);
        return true;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        Player player;
        return entity instanceof Player && this.canFly(player = (Player)entity, stack) && this.isFullFlightEnabled(player);
    }
}

