/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks;

import earth.terrarium.adastra.common.blocks.properties.LaunchPadPartProperty;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LaunchPadBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<LaunchPadPartProperty> PART = EnumProperty.m_61587_((String)"part", LaunchPadPartProperty.class);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public LaunchPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)LaunchPadPartProperty.CENTER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, POWERED, PART});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.LAUNCH_PAD_INFO);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return ((LaunchPadPartProperty)((Object)state.m_61143_(PART))).isController() ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().equals(Fluids.f_76193_)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.m_5776_()) {
            BlockPos controllerPos = this.getController(state, pos);
            BlockState controllerState = level.m_8055_(controllerPos);
            if (controllerState.m_60795_()) {
                return;
            }
            level.m_7731_(controllerPos, (BlockState)controllerState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))), 2);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        for (LaunchPadPartProperty part : LaunchPadPartProperty.values()) {
            BlockPos partPos = pos.m_122013_(part.xOffset()).m_122030_(part.yOffset());
            level.m_7731_(partPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)part)), 2);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (!Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_())) {
            return false;
        }
        for (LaunchPadPartProperty part : LaunchPadPartProperty.values()) {
            BlockPos offset = pos.m_122013_(part.xOffset()).m_122030_(part.yOffset());
            if (level.m_8055_(offset).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.destroy(level, pos, state);
        super.m_5707_(level, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.m_5776_()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offset = pos.m_121945_(direction);
                BlockState state = level.m_8055_(offset);
                if (!state.m_60734_().equals((Object)this)) continue;
                this.destroy(level, offset, state);
                break;
            }
        }
        super.m_7592_(level, pos, explosion);
    }

    private void destroy(Level level, BlockPos pos, BlockState state) {
        BlockPos controllerPos = this.getController(state, pos);
        for (LaunchPadPartProperty part : LaunchPadPartProperty.values()) {
            BlockPos partPos = controllerPos.m_122013_(part.xOffset()).m_122030_(part.yOffset());
            level.m_46961_(partPos, true);
        }
    }

    public BlockPos getController(BlockState state, BlockPos pos) {
        LaunchPadPartProperty part = (LaunchPadPartProperty)((Object)state.m_61143_(PART));
        return pos.m_122020_(part.xOffset()).m_122025_(part.yOffset());
    }
}

