/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.client.components.LabeledImageButton;
import earth.terrarium.adastra.client.utils.DimensionRenderingUtils;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.constants.PlanetConstants;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundLandOnSpaceStationPacket;
import earth.terrarium.adastra.common.network.messages.ServerboundLandPacket;
import earth.terrarium.adastra.common.planets.AdAstraData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class PlanetsScreen
extends AbstractContainerScreen<PlanetsMenu> {
    public static final ResourceLocation BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/planets/button.png");
    public static final ResourceLocation BACK_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/planets/back_button.png");
    public static final ResourceLocation PLUS_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/planets/plus_button.png");
    public static final ResourceLocation SELECTION_MENU = new ResourceLocation("ad_astra", "textures/gui/sprites/planets/selection_menu.png");
    public static final ResourceLocation SMALL_SELECTION_MENU = new ResourceLocation("ad_astra", "textures/gui/sprites/planets/small_selection_menu.png");
    private final List<Button> buttons = new ArrayList<Button>();
    private Button backButton;
    private double scrollAmount;
    private final List<Button> spaceStationButtons = new ArrayList<Button>();
    private Button addSpaceStatonButton;
    private double spaceStationScrollAmount;
    private final boolean hasMultipleSolarSystems;
    private int pageIndex;
    @Nullable
    private ResourceLocation selectedSolarSystem = PlanetConstants.SOLAR_SYSTEM;
    @Nullable
    private Planet selectedPlanet;

    public PlanetsScreen(PlanetsMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = this.f_96543_;
        this.f_97727_ = this.f_96544_;
        List<Planet> planets = AdAstraData.planets().values().stream().filter(planet -> !menu.disabledPlanets().contains(planet.dimension().m_135782_())).filter(planet -> menu.tier() >= planet.tier()).toList();
        this.hasMultipleSolarSystems = planets.stream().map(Planet::solarSystem).distinct().count() > 1L;
        this.pageIndex = this.hasMultipleSolarSystems ? 0 : 1;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttons.clear();
        this.spaceStationButtons.clear();
        this.spaceStationScrollAmount = 0.0;
        switch (this.pageIndex) {
            case 0: {
                this.createSolarSystemButtons();
                break;
            }
            case 1: 
            case 2: {
                this.createPlanetButtons();
                if (this.pageIndex != 2 || this.selectedPlanet == null) break;
                this.createSelectedPlanetButtons();
            }
        }
        this.backButton = (Button)this.m_142416_((GuiEventListener)new LabeledImageButton(10, this.f_96544_ / 2 - 85, 12, 12, 0, 12, 12, BACK_BUTTON, 12, 24, b -> {
            --this.pageIndex;
            this.m_232761_();
        }));
        this.addSpaceStatonButton = (Button)this.m_142416_((GuiEventListener)new LabeledImageButton(114, this.f_96544_ / 2 - 41, 12, 12, 0, 12, 12, PLUS_BUTTON, 12, 24, b -> {
            if (this.selectedPlanet != null) {
                int ownedSpaceStationCount = ((PlanetsMenu)this.f_97732_).getOwnedAndTeamSpaceStations(this.selectedPlanet.orbitIfPresent()).size();
                MutableComponent name = Component.m_237110_((String)"text.ad_astra.text.space_station_name", (Object[])new Object[]{ownedSpaceStationCount + 1});
                ((PlanetsMenu)this.f_97732_).constructSpaceStation(this.selectedPlanet.dimension(), (Component)name);
                this.close();
            }
        }));
        if (this.selectedPlanet != null) {
            this.addSpaceStatonButton.m_257544_(this.getSpaceStationRecipeTooltip(this.selectedPlanet.orbitIfPresent()));
            this.addSpaceStatonButton.f_93623_ = this.selectedPlanet != null && ((PlanetsMenu)this.f_97732_).canConstruct(this.selectedPlanet.orbitIfPresent()) && !((PlanetsMenu)this.f_97732_).isInSpaceStation(this.selectedPlanet.orbitIfPresent());
        }
        this.backButton.f_93624_ = this.pageIndex > (this.hasMultipleSolarSystems ? 0 : 1);
        this.addSpaceStatonButton.f_93624_ = this.pageIndex == 2 && this.selectedPlanet != null;
    }

    private void createSolarSystemButtons() {
        this.selectedSolarSystem = null;
        AdAstraData.solarSystems().forEach(solarSystem -> {
            LabeledImageButton button = (LabeledImageButton)this.m_7787_((GuiEventListener)new LabeledImageButton(10, 0, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> {
                this.pageIndex = 1;
                this.selectedSolarSystem = solarSystem;
                this.m_232761_();
            }, (Component)Component.m_264568_((String)"solar_system.%s.%s".formatted(solarSystem.m_135827_(), solarSystem.m_135815_()), (String)this.title(solarSystem.m_135815_()))));
            this.buttons.add((Button)button);
        });
    }

    private void createPlanetButtons() {
        for (Planet planet : ((PlanetsMenu)this.f_97732_).getSortedPlanets()) {
            if (planet.isSpace() || ((PlanetsMenu)this.f_97732_).tier() < planet.tier() || !planet.solarSystem().equals((Object)this.selectedSolarSystem)) continue;
            this.buttons.add((Button)this.m_7787_((GuiEventListener)new LabeledImageButton(10, 0, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> {
                this.pageIndex = 2;
                this.selectedPlanet = planet;
                this.m_232761_();
            }, ((PlanetsMenu)this.f_97732_).getPlanetName(planet.dimension()))));
        }
    }

    private void createSelectedPlanetButtons() {
        if (this.selectedPlanet == null) {
            return;
        }
        BlockPos pos = ((PlanetsMenu)this.f_97732_).getLandingPos(this.selectedPlanet.dimension(), true);
        LabeledImageButton button = (LabeledImageButton)this.m_142416_((GuiEventListener)new LabeledImageButton(114, this.f_96544_ / 2 - 77, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> this.land(this.selectedPlanet.dimension()), ConstantComponents.LAND));
        button.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"tooltip.ad_astra.land", (Object[])new Object[]{((PlanetsMenu)this.f_97732_).getPlanetName(this.selectedPlanet.dimension()), pos.m_123341_(), pos.m_123343_()}).m_130940_(ChatFormatting.AQUA)));
        this.addSpaceStationButtons(this.selectedPlanet.orbitIfPresent());
    }

    private void addSpaceStationButtons(ResourceKey<Level> dimension) {
        ((PlanetsMenu)this.f_97732_).getOwnedAndTeamSpaceStations(dimension).forEach(station -> {
            ChunkPos pos = ((SpaceStation)station.getSecond()).position();
            LabeledImageButton button = (LabeledImageButton)this.m_7787_((GuiEventListener)new LabeledImageButton(114, this.f_96544_ / 2, 99, 20, 0, 0, 20, BUTTON, 99, 40, b -> this.landOnSpaceStation(dimension, pos), ((SpaceStation)station.getSecond()).name()));
            button.m_257544_(this.getSpaceStationLandTooltip(dimension, pos, (String)station.getFirst()));
            this.spaceStationButtons.add((Button)button);
        });
    }

    public Tooltip getSpaceStationLandTooltip(ResourceKey<Level> dimension, ChunkPos pos, String owner) {
        return Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])new Component[]{Component.m_237110_((String)"tooltip.ad_astra.space_station_land", (Object[])new Object[]{((PlanetsMenu)this.f_97732_).getPlanetName(dimension), pos.m_151390_(), pos.m_151393_()}).m_130940_(ChatFormatting.AQUA), Component.m_237110_((String)"tooltip.ad_astra.space_station_owner", (Object[])new Object[]{owner}).m_130940_(ChatFormatting.GOLD)}));
    }

    public Tooltip getSpaceStationRecipeTooltip(ResourceKey<Level> planet) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        BlockPos pos = ((PlanetsMenu)this.f_97732_).getLandingPos(planet, false);
        tooltip.add(Component.m_237110_((String)"tooltip.ad_astra.construct_space_station_at", (Object[])new Object[]{((PlanetsMenu)this.f_97732_).getPlanetName(planet), pos.m_123341_(), pos.m_123343_()}).m_130940_(ChatFormatting.AQUA));
        if (((PlanetsMenu)this.f_97732_).isInSpaceStation(planet) || ((PlanetsMenu)this.f_97732_).isClaimed(planet)) {
            tooltip.add(ConstantComponents.SPACE_STATION_ALREADY_EXISTS);
            return Tooltip.m_257550_((Component)CommonComponents.m_178391_(tooltip));
        }
        tooltip.add(ConstantComponents.CONSTRUCTION_COST.m_6881_().m_130940_(ChatFormatting.AQUA));
        List<Pair<ItemStack, Integer>> ingredients = ((PlanetsMenu)this.f_97732_).ingredients().get(planet);
        if (ingredients == null) {
            return Tooltip.m_257550_((Component)CommonComponents.m_178391_(tooltip));
        }
        for (Pair<ItemStack, Integer> ingredient : ingredients) {
            ItemStack stack = (ItemStack)ingredient.getFirst();
            int amountOwned = (Integer)ingredient.getSecond();
            boolean hasEnough = ((PlanetsMenu)this.f_97732_).player().m_7500_() || ((PlanetsMenu)this.f_97732_).player().m_5833_() || amountOwned >= stack.m_41613_();
            tooltip.add(Component.m_237110_((String)"tooltip.ad_astra.requirement", (Object[])new Object[]{amountOwned, stack.m_41613_(), stack.m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)}).m_6881_().m_130940_(hasEnough ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        return Tooltip.m_257550_((Component)CommonComponents.m_178391_(tooltip));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderButtons(graphics, mouseX, mouseY, partialTick);
        this.backButton.f_93624_ = this.pageIndex > (this.hasMultipleSolarSystems ? 0 : 1);
        this.addSpaceStatonButton.f_93624_ = this.pageIndex == 2 && this.selectedPlanet != null;
    }

    /*
     * WARNING - void declaration
     */
    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int scrollPixels = (int)this.scrollAmount;
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)0, (int)(this.f_96544_ / 2 - 43), (int)112, (int)131);){
            for (Button button : this.buttons) {
                button.m_88315_(graphics, mouseX, mouseY, partialTick);
            }
            for (int i = 0; i < this.buttons.size(); ++i) {
                Button button = this.buttons.get(i);
                button.m_253211_(i * 24 - scrollPixels + (this.f_96544_ / 2 - 41));
            }
        }
        if (this.pageIndex == 2 && this.selectedPlanet != null) {
            int spaceStationScrollPixels = (int)this.spaceStationScrollAmount;
            try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)112, (int)(this.f_96544_ / 2 - 2), (int)112, (int)90);){
                void var8_18;
                for (Button button : this.spaceStationButtons) {
                    button.m_88315_(graphics, mouseX, mouseY, partialTick);
                }
                boolean bl = false;
                while (var8_18 < this.spaceStationButtons.size()) {
                    Button button;
                    button = this.spaceStationButtons.get((int)var8_18);
                    button.m_253211_((int)(var8_18 * 24 - spaceStationScrollPixels + this.f_96544_ / 2));
                    ++var8_18;
                }
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        if (this.pageIndex == 2) {
            graphics.m_280163_(SELECTION_MENU, 7, this.f_96544_ / 2 - 88, 0.0f, 0.0f, 209, 177, 209, 177);
            graphics.m_280653_(this.f_96547_, ConstantComponents.SPACE_STATION, 163, this.f_96544_ / 2 - 15, 0xFFFFFF);
        } else {
            graphics.m_280163_(SMALL_SELECTION_MENU, 7, this.f_96544_ / 2 - 88, 0.0f, 0.0f, 105, 177, 105, 177);
        }
        if (this.pageIndex == 2 && this.selectedPlanet != null) {
            MutableComponent title = Component.m_264568_((String)"planet.%s.%s".formatted(this.selectedPlanet.dimension().m_135782_().m_135827_(), this.selectedPlanet.dimension().m_135782_().m_135815_()), (String)this.title(this.selectedPlanet.dimension().m_135782_().m_135815_()));
            graphics.m_280653_(this.f_96547_, (Component)title, 57, this.f_96544_ / 2 - 60, 0xFFFFFF);
        } else if (this.pageIndex == 1 && this.selectedSolarSystem != null) {
            MutableComponent title = Component.m_264568_((String)"solar_system.%s.%s".formatted(this.selectedSolarSystem.m_135827_(), this.selectedSolarSystem.m_135815_()), (String)this.title(this.selectedSolarSystem.m_135815_()));
            graphics.m_280653_(this.f_96547_, (Component)title, 57, this.f_96544_ / 2 - 60, 0xFFFFFF);
        } else {
            graphics.m_280653_(this.f_96547_, ConstantComponents.CATALOG, 57, this.f_96544_ / 2 - 60, 0xFFFFFF);
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        int i;
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16776167);
        RenderSystem.setShader(GameRenderer::m_172757_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        for (i = -this.f_96544_; i <= this.f_96543_; i += 24) {
            bufferBuilder.m_5483_((double)i, 0.0, 0.0).m_193479_(-15784615).m_5752_();
            bufferBuilder.m_5483_((double)(i + this.f_96544_), (double)this.f_96544_, 0.0).m_193479_(-15784615).m_5752_();
        }
        for (i = this.f_96543_ + this.f_96544_; i >= 0; i -= 24) {
            bufferBuilder.m_5483_((double)i, 0.0, 0.0).m_193479_(-15784615).m_5752_();
            bufferBuilder.m_5483_((double)(i - this.f_96544_), (double)this.f_96544_, 0.0).m_193479_(-15784615).m_5752_();
        }
        if (PlanetConstants.PROXIMA_CENTAURI.equals((Object)this.selectedSolarSystem)) {
            this.drawCircles(1, 1, -16744320, bufferBuilder);
        } else if (PlanetConstants.SOLAR_SYSTEM.equals((Object)this.selectedSolarSystem)) {
            this.drawCircles(0, 4, -14404997, bufferBuilder);
        }
        tessellator.m_85914_();
        if (PlanetConstants.PROXIMA_CENTAURI.equals((Object)this.selectedSolarSystem)) {
            this.renderProximaCentauri(graphics);
        } else if (PlanetConstants.SOLAR_SYSTEM.equals((Object)this.selectedSolarSystem)) {
            this.renderSolarSystem(graphics);
        }
    }

    public void renderSolarSystem(GuiGraphics graphics) {
        graphics.m_280163_(DimensionRenderingUtils.SUN, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        float yRot = (float)Util.m_137550_() / 100.0f;
        for (int i = 1; i < 5; ++i) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(yRot * (float)(5 - i) / 2.0f));
            graphics.m_280168_().m_252880_((float)(31 * i - 10), 0.0f, 0.0f);
            graphics.m_280163_(DimensionRenderingUtils.SOLAR_SYSTEM_TEXTURES.get(i - 1), 0, 0, 0.0f, 0.0f, 12, 12, 12, 12);
            graphics.m_280168_().m_85849_();
        }
    }

    public void renderProximaCentauri(GuiGraphics graphics) {
        graphics.m_280163_(DimensionRenderingUtils.BLUE_SUN, this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        float yRot = (float)Util.m_137550_() / 100.0f % 360.0f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(yRot));
        graphics.m_280168_().m_252880_(53.0f, 0.0f, 0.0f);
        graphics.m_280163_(DimensionRenderingUtils.GLACIO, 0, 0, 0.0f, 0.0f, 12, 12, 12, 12);
        graphics.m_280168_().m_85849_();
    }

    public void drawCircles(int start, int count, int color, BufferBuilder bufferBuilder) {
        for (int i = 1 + start; i < count + start + 1; ++i) {
            PlanetsScreen.drawCircle(bufferBuilder, (float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 30 * i, 75, color);
        }
    }

    public static void drawCircle(BufferBuilder bufferBuilder, double x, double y, double radius, int sides, int color) {
        for (double r = radius - 0.5; r <= radius + 0.5; r += 0.1) {
            for (int i = 0; i < sides; ++i) {
                double angle = (double)i * 2.0 * Math.PI / (double)sides;
                double nextAngle = (double)(i + 1) * 2.0 * Math.PI / (double)sides;
                double x1 = x + r * Math.cos(angle);
                double y1 = y + r * Math.sin(angle);
                double x2 = x + r * Math.cos(nextAngle);
                double y2 = y + r * Math.sin(nextAngle);
                bufferBuilder.m_5483_(x1, y1, 0.0).m_193479_(color).m_5752_();
                bufferBuilder.m_5483_(x2, y2, 0.0).m_193479_(color).m_5752_();
            }
        }
    }

    public boolean m_7043_() {
        return true;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX < 112.0 && mouseX > 6.0 && mouseY > (double)((float)this.f_96544_ / 2.0f - 43.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f + 88.0f)) {
            this.setScrollAmount(this.scrollAmount - delta * 16.0 / 2.0);
        } else if (mouseX > 112.0 && mouseX < 224.0 && mouseY > (double)((float)this.f_96544_ / 2.0f - 2.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f + 88.0f)) {
            this.setSpaceStationScrollAmount(this.spaceStationScrollAmount - delta * 16.0 / 2.0);
        }
        return true;
    }

    public void m_7379_() {
        if (this.pageIndex > 0) {
            --this.pageIndex;
            this.m_232761_();
            return;
        }
        Player player = ((PlanetsMenu)this.f_97732_).player();
        if (player.m_7500_() || player.m_5833_()) {
            super.m_7379_();
        } else if (!(player.m_20202_() instanceof Rocket)) {
            super.m_7379_();
        }
    }

    protected void close() {
        this.pageIndex = 0;
        this.m_7379_();
    }

    protected void setScrollAmount(double amount) {
        this.scrollAmount = Mth.m_14008_((double)amount, (double)0.0, (double)Math.max(0, this.buttons.size() * 24 - 131));
    }

    protected void setSpaceStationScrollAmount(double amount) {
        this.spaceStationScrollAmount = Mth.m_14008_((double)amount, (double)0.0, (double)Math.max(0, this.spaceStationButtons.size() * 24 - 90));
    }

    public void land(ResourceKey<Level> dimension) {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundLandPacket(dimension, true));
        this.close();
    }

    public void landOnSpaceStation(ResourceKey<Level> dimension, ChunkPos pos) {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundLandOnSpaceStationPacket(dimension, pos));
        this.close();
    }

    private String title(String string) {
        return WordUtils.capitalizeFully((String)string.replace("_", " "));
    }
}

