/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.models.armor;

import architectury_inject_ad_astra_common_e9854e859cb44cf8acc80860d6cf578a_e4e6619bcc6fc4a628f9bee70b40b917fb1c8cc99bd622b688edecb9a9f43cc4ad_astracommon120111518devjar.PlatformMethods;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.adastra.client.ClientPlatformUtils;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.tags.ModItemTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SpaceSuitModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation SPACE_SUIT_LAYER = new ModelLayerLocation(new ResourceLocation("ad_astra", "space_suit"), "main");
    public static final ModelLayerLocation NETHERITE_SPACE_SUIT_LAYER = new ModelLayerLocation(new ResourceLocation("ad_astra", "netherite_space_suit"), "main");
    public static final ModelLayerLocation JET_SUIT_LAYER = new ModelLayerLocation(new ResourceLocation("ad_astra", "jet_suit"), "main");
    public static final ResourceLocation SPACE_SUIT_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/armor/space_suit.png");
    public static final ResourceLocation NETHERITE_SPACE_SUIT_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/armor/netherite_space_suit.png");
    public static final ResourceLocation JET_SUIT_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/armor/jet_suit.png");
    private final ModelPart visor;
    private final ModelPart belt;
    private final ModelPart rightBoot;
    private final ModelPart leftBoot;
    @Nullable
    private final ResourceLocation texture;
    private final EquipmentSlot slot;
    @Nullable
    private final HumanoidModel<LivingEntity> parentModel;
    private float r;
    private float g;
    private float b;

    public SpaceSuitModel(ModelPart root, EquipmentSlot slot, ItemStack stack, @Nullable HumanoidModel<LivingEntity> parentModel) {
        super(root, RenderType::m_110473_);
        this.visor = root.m_171324_("visor");
        this.belt = root.m_171324_("belt");
        this.rightBoot = root.m_171324_("left_boot");
        this.leftBoot = root.m_171324_("right_boot");
        this.slot = slot;
        this.parentModel = parentModel;
        this.texture = SpaceSuitModel.getTextureLocation(stack);
        this.setVisible();
        Item item = stack.m_41720_();
        if (item instanceof DyeableArmorItem) {
            DyeableArmorItem armor = (DyeableArmorItem)item;
            int color = armor.m_41121_(stack);
            this.r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            this.g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            this.b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if ("forge".equals(PlatformMethods.getCurrentTarget()) && this.texture != null) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.texture));
        }
        if (this.parentModel == null) {
            return;
        }
        this.visor.m_104315_(this.parentModel.f_102808_);
        this.belt.m_104315_(this.parentModel.f_102810_);
        this.rightBoot.m_104315_(this.parentModel.f_102813_);
        this.leftBoot.m_104315_(this.parentModel.f_102814_);
        this.parentModel.m_102872_((HumanoidModel)this);
        super.m_7695_(poseStack, buffer, packedLight, packedOverlay, this.r, this.g, this.b, alpha);
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.visor.f_104207_ = visible;
        this.belt.f_104207_ = visible;
        this.rightBoot.f_104207_ = visible;
        this.leftBoot.f_104207_ = visible;
    }

    private void setVisible() {
        this.m_8009_(false);
        switch (this.slot) {
            case HEAD: {
                this.f_102808_.f_104207_ = true;
                this.visor.f_104207_ = true;
                break;
            }
            case CHEST: {
                this.f_102810_.f_104207_ = true;
                this.f_102811_.f_104207_ = true;
                this.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                this.belt.f_104207_ = true;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                this.rightBoot.f_104207_ = true;
                this.leftBoot.f_104207_ = true;
            }
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_, (Object)this.visor);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_, (Object)this.belt, (Object)this.rightBoot, (Object)this.leftBoot);
    }

    @Nullable
    public static ModelLayerLocation getLayerLocation(ItemStack stack) {
        if (stack.m_150930_((Item)ModItems.SPACE_SUIT.get())) {
            return SPACE_SUIT_LAYER;
        }
        if (stack.m_150930_((Item)ModItems.NETHERITE_SPACE_SUIT.get())) {
            return NETHERITE_SPACE_SUIT_LAYER;
        }
        if (stack.m_150930_((Item)ModItems.JET_SUIT.get())) {
            return JET_SUIT_LAYER;
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getTextureLocation(ItemStack stack) {
        if (stack.m_204117_(ModItemTags.JET_SUITS)) {
            return JET_SUIT_TEXTURE;
        }
        if (stack.m_204117_(ModItemTags.NETHERITE_SPACE_SUITS)) {
            return NETHERITE_SPACE_SUIT_TEXTURE;
        }
        if (stack.m_204117_(ModItemTags.SPACE_SUITS)) {
            return SPACE_SUIT_TEXTURE;
        }
        return null;
    }

    public static LayerDefinition createSpaceSuitLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition visor = modelPartData.m_171599_("visor", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = modelPartData.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.f_171404_);
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition belt = modelPartData.m_171599_("belt", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition backpack = body.m_171599_("backpack", CubeListBuilder.m_171558_().m_171514_(32, 44).m_171488_(-6.0f, -8.0f, -2.0f, 12.0f, 16.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)5.0f));
        PartDefinition right_arm = modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r1 = right_arm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r2 = left_arm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_boot = modelPartData.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)).m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_boot = modelPartData.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)).m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public static LayerDefinition createNetheriteSpaceSuitLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition visor = modelPartData.m_171599_("visor", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition hat = modelPartData.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.f_171404_);
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition belt = modelPartData.m_171599_("belt", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition backpack = body.m_171599_("backpack", CubeListBuilder.m_171558_().m_171514_(32, 46).m_171488_(-5.0f, -7.0f, -2.0f, 10.0f, 14.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)5.0f));
        PartDefinition right_arm = modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition cube_r1 = right_arm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-2.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(16, 48).m_171488_(-2.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        PartDefinition cube_r2 = left_arm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171480_().m_171488_(-1.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(16, 48).m_171488_(-1.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_boot = modelPartData.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_boot = modelPartData.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public static LayerDefinition createJetSuitLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = modelPartData.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.f_171404_);
        PartDefinition visor = modelPartData.m_171599_("visor", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)).m_171514_(32, 48).m_171488_(-4.0f, -1.0f, 3.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).m_171514_(32, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.9f)), PartPose.m_171419_((float)1.0f, (float)0.5f, (float)0.0f));
        PartDefinition belt = modelPartData.m_171599_("belt", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition backpack = body.m_171599_("backpack", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)5.0f));
        PartDefinition right_arm = modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.5f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r1 = right_arm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-2.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(16, 48).m_171488_(-2.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.5f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r2 = left_arm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171480_().m_171488_(-1.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(16, 48).m_171488_(-1.5f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_boot = modelPartData.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_boot = modelPartData.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public static void register(ClientPlatformUtils.LayerDefinitionRegistry registry) {
        registry.register(SPACE_SUIT_LAYER, SpaceSuitModel::createSpaceSuitLayer);
        registry.register(NETHERITE_SPACE_SUIT_LAYER, SpaceSuitModel::createNetheriteSpaceSuitLayer);
        registry.register(JET_SUIT_LAYER, SpaceSuitModel::createJetSuitLayer);
    }
}

