/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import satisfy.bakery.Bakery;
import satisfy.bakery.effect.StuffedEffect;
import satisfy.bakery.effect.SweetsEffect;
import satisfy.bakery.util.BakeryIdentifier;

public class EffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"bakery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> STUFFED = EffectRegistry.registerEffect("stuffed", StuffedEffect::new);
    public static final RegistrySupplier<MobEffect> SWEETS = EffectRegistry.registerEffect("sweets", SweetsEffect::new);

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new BakeryIdentifier(name), effect);
    }

    public static void init() {
        Bakery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }
}

