/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import satisfy.bakery.client.gui.handler.StoveGuiHandler;
import satisfy.bakery.compat.jei.category.BakerStationCategory;
import satisfy.bakery.compat.jei.category.CookingPotCategory;
import satisfy.bakery.compat.jei.category.CraftingBowlCategory;
import satisfy.bakery.compat.jei.category.StoveCategory;
import satisfy.bakery.compat.jei.transfer.CookingTransferInfo;
import satisfy.bakery.registry.ObjectRegistry;
import satisfy.bakery.registry.RecipeTypeRegistry;
import satisfy.bakery.registry.ScreenHandlerTypeRegistry;
import satisfy.bakery.util.BakeryIdentifier;

@JeiPlugin
public class BakeryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPotCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StoveCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CraftingBowlCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BakerStationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List fridgeRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get());
        registration.addRecipes(CookingPotCategory.COOKING_POT, fridgeRecipes);
        List stoveRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get());
        registration.addRecipes(StoveCategory.STOVE, stoveRecipes);
        List cakingRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.BAKING_STATION_RECIPE_TYPE.get());
        registration.addRecipes(BakerStationCategory.CAKING, cakingRecipes);
        List doughingRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get());
        registration.addRecipes(CraftingBowlCategory.DOUGHING, doughingRecipes);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new BakeryIdentifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CookingTransferInfo());
        registration.addRecipeTransferHandler(StoveGuiHandler.class, (MenuType)ScreenHandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), StoveCategory.STOVE, 1, 3, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.SMALL_COOKING_POT.get()).m_5456_().m_7968_(), new RecipeType[]{CookingPotCategory.COOKING_POT});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.BAKER_STATION.get()).m_5456_().m_7968_(), new RecipeType[]{BakerStationCategory.CAKING});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.CRAFTING_BOWL.get()).m_5456_().m_7968_(), new RecipeType[]{CraftingBowlCategory.DOUGHING});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.BRICK_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.STONE_BRICKS_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.COBBLESTONE_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.DEEPSLATE_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.GRANITE_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.MUD_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.SANDSTONE_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.END_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.QUARTZ_STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{StoveCategory.STOVE});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

