/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfy.bakery.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum CookingPotRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    JAM(new ItemStack((ItemLike)ObjectRegistry.SWEETBERRY_JAM.get())),
    CHOCOLATE(new ItemStack((ItemLike)ObjectRegistry.CHOCOLATE_TRUFFLE.get()));

    public static final List<IRecipeBookGroup> POT_GROUPS;
    private final List<ItemStack> icons;

    private CookingPotRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<? extends Container> recipe, RegistryAccess registryAccess) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SEARCH -> true;
            case JAM -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(((Block)ObjectRegistry.JAR.get()).m_5456_().m_7968_()));
            case CHOCOLATE -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(Items.f_42455_.m_7968_()));
        };
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        POT_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)JAM), (Object)((Object)CHOCOLATE));
    }
}

