/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.block.entity;

import de.cristelknight.doapi.common.world.ImplementedInventory;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfy.bakery.block.StoveBlock;
import satisfy.bakery.client.gui.handler.StoveGuiHandler;
import satisfy.bakery.recipe.StoveRecipe;
import satisfy.bakery.registry.BlockEntityTypeRegistry;
import satisfy.bakery.registry.RecipeTypeRegistry;

public class StoveBlockEntity
extends BlockEntity
implements BlockEntityTicker<StoveBlockEntity>,
ImplementedInventory,
MenuProvider {
    private NonNullList<ItemStack> inventory;
    protected int burnTime;
    protected int burnTimeTotal;
    protected int cookTime;
    protected int cookTimeTotal;
    protected float experience;
    protected static final int FUEL_SLOT = 4;
    protected static final int[] INGREDIENT_SLOTS = new int[]{1, 2, 3};
    protected static final int OUTPUT_SLOT = 0;
    public static final int TOTAL_COOKING_TIME = 240;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> StoveBlockEntity.this.burnTime;
                case 1 -> StoveBlockEntity.this.burnTimeTotal;
                case 2 -> StoveBlockEntity.this.cookTime;
                case 3 -> StoveBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    StoveBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    StoveBlockEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    StoveBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    StoveBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public int[] getIngredientSlots() {
        return INGREDIENT_SLOTS;
    }

    public int getOutputSlot() {
        return 0;
    }

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypeRegistry.STOVE_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    }

    public void dropExperience(ServerLevel world, Vec3 pos) {
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)pos, (int)((int)this.experience));
    }

    public int @NotNull [] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return INGREDIENT_SLOTS;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return new int[]{0};
        }
        return new int[]{4};
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.burnTime = nbt.m_128448_("BurnTime");
        this.cookTime = nbt.m_128448_("CookTime");
        this.cookTimeTotal = nbt.m_128448_("CookTimeTotal");
        this.burnTimeTotal = this.getTotalBurnTime(this.m_8020_(4));
        this.experience = nbt.m_128457_("Experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128376_("BurnTime", (short)this.burnTime);
        nbt.m_128376_("CookTime", (short)this.cookTime);
        nbt.m_128376_("CookTimeTotal", (short)this.cookTimeTotal);
        nbt.m_128350_("Experience", this.experience);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    protected boolean isBurning() {
        return this.burnTime > 0;
    }

    public void tick(Level world, BlockPos pos, BlockState state, StoveBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
        boolean initialBurningState = blockEntity.isBurning();
        boolean dirty = false;
        if (initialBurningState) {
            --this.burnTime;
        }
        StoveRecipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        assert (this.f_58857_ != null);
        RegistryAccess access = this.f_58857_.m_9598_();
        if (!initialBurningState && this.canCraft(recipe, access)) {
            this.burnTime = this.burnTimeTotal = this.getTotalBurnTime(this.m_8020_(4));
            if (this.burnTime > 0) {
                dirty = true;
                ItemStack fuelStack = this.m_8020_(4);
                if (fuelStack.m_41720_().m_41470_()) {
                    this.m_6836_(4, new ItemStack((ItemLike)Objects.requireNonNull(fuelStack.m_41720_().m_41469_())));
                } else if (fuelStack.m_41613_() > 1) {
                    this.m_7407_(4, 1);
                } else if (fuelStack.m_41613_() == 1) {
                    this.m_6836_(4, ItemStack.f_41583_);
                }
            }
        }
        if (this.isBurning() && this.canCraft(recipe, access)) {
            ++this.cookTime;
            if (this.cookTime == this.cookTimeTotal) {
                this.cookTime = 0;
                this.craft(recipe, access);
                dirty = true;
            }
        } else if (!this.canCraft(recipe, access)) {
            this.cookTime = 0;
        }
        if (initialBurningState != this.isBurning() && (Boolean)state.m_61143_((Property)StoveBlock.LIT) != this.burnTime > 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(this.burnTime > 0)), 3);
            dirty = true;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    protected boolean canCraft(StoveRecipe recipe, RegistryAccess access) {
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        if (this.m_8020_(4).m_41619_()) {
            return false;
        }
        ItemStack recipeOutput = recipe.m_8043_(access);
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            return false;
        }
        int outputSlotCount = outputSlotStack.m_41613_();
        return outputSlotCount + recipeOutput.m_41613_() <= outputSlotStack.m_41741_();
    }

    protected void craft(StoveRecipe recipe, RegistryAccess access) {
        if (recipe == null || !this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access).m_41777_();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput);
        } else if (ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        block0: for (int slot : INGREDIENT_SLOTS) {
            ItemStack stackInSlot = this.m_8020_(slot);
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(stackInSlot)) continue;
                ItemStack remainderStack = this.getRemainderItem(stackInSlot);
                stackInSlot.m_41774_(1);
                if (remainderStack.m_41619_()) continue block0;
                if (stackInSlot.m_41619_()) {
                    this.m_6836_(slot, remainderStack);
                    continue block0;
                }
                boolean added = false;
                for (int i : INGREDIENT_SLOTS) {
                    ItemStack is = this.m_8020_(i);
                    if (is.m_41619_()) {
                        this.m_6836_(i, remainderStack.m_41777_());
                        added = true;
                        break;
                    }
                    if (!ItemStack.m_150942_((ItemStack)is, (ItemStack)remainderStack) || is.m_41613_() >= is.m_41741_()) continue;
                    is.m_41769_(1);
                    added = true;
                    break;
                }
                if (added) continue block0;
                assert (this.f_58857_ != null);
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)remainderStack);
                continue block0;
            }
        }
    }

    protected int getTotalBurnTime(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        Item item = fuel.m_41720_();
        HashMap<Item, Integer> fuelBurnTimes = new HashMap<Item, Integer>();
        fuelBurnTimes.put(Items.f_42413_, 1600);
        fuelBurnTimes.put(Items.f_42414_, 1600);
        fuelBurnTimes.put(Items.f_42448_, 20000);
        fuelBurnTimes.put(Items.f_42585_, 2400);
        return fuelBurnTimes.getOrDefault(item, 0);
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        boolean hasIngredientChange = false;
        for (int ingredientSlot : INGREDIENT_SLOTS) {
            if (ItemStack.m_150942_((ItemStack)this.m_8020_(ingredientSlot), (ItemStack)stackInSlot)) continue;
            hasIngredientChange = true;
            break;
        }
        if (hasIngredientChange && !dirty) {
            this.cookTimeTotal = 240;
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new StoveGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }
}

