/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ShapelessFluxCrafterRecipe
implements ISpecialRecipe,
IFluxCrafterRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int powerRequired;
    private final int powerRate;

    public ShapelessFluxCrafterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, int powerRequired) {
        this(recipeId, inputs, output, powerRequired, (Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
    }

    public ShapelessFluxCrafterRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, int powerRequired, int powerRate) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.powerRequired = powerRequired;
        this.powerRate = powerRate;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_FLUX_CRAFTER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FLUX_CRAFTER.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputs.size();
    }

    public ItemStack assemble(IItemHandler inventory, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public int getPowerRequired() {
        return this.powerRequired;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessFluxCrafterRecipe> {
        public ShapelessFluxCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int powerRequired = GsonHelper.m_13927_((JsonObject)json, (String)"powerRequired");
            int powerRate = GsonHelper.m_13824_((JsonObject)json, (String)"powerRate", (int)((Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get()));
            return new ShapelessFluxCrafterRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, powerRequired, powerRate);
        }

        public ShapelessFluxCrafterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int powerRequired = buffer.m_130242_();
            int powerRate = buffer.m_130242_();
            return new ShapelessFluxCrafterRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, powerRequired, powerRate);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessFluxCrafterRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.powerRequired);
            buffer.m_130130_(recipe.powerRate);
        }
    }
}

