/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.track.outfitted.ReversibleOutfittedTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public abstract class SwitchTrackBlock
extends ReversibleOutfittedTrackBlock {
    public static final BooleanProperty SWITCHED = BooleanProperty.m_61465_((String)"switched");
    public static final EnumProperty<RailShape> SHAPE = EnumProperty.m_61598_((String)"shape", RailShape.class, (Enum[])new RailShape[]{RailShape.NORTH_SOUTH, RailShape.EAST_WEST});

    public SwitchTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).m_61124_((Property)SWITCHED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SWITCHED});
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        super.m_6807_(state, level, pos, oldBlockState, moved);
        this.updateAdjacentBlocks(state, level, pos);
    }

    protected void updateAdjacentBlocks(BlockState blockState, Level level, BlockPos pos) {
        RailShape railShape = TrackUtil.getRailShapeRaw(blockState);
        boolean reversed = (Boolean)blockState.m_61143_((Property)REVERSED);
        switch (railShape) {
            case EAST_WEST: {
                BlockPos offset;
                BlockPos blockPos = offset = reversed ? pos.m_122012_() : pos.m_122019_();
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)offset)) {
                    return;
                }
                RailShape otherShape = TrackUtil.getTrackDirection((BlockGetter)level, offset);
                if (otherShape == RailShape.NORTH_SOUTH) break;
                TrackUtil.setRailShape(level, offset, RailShape.NORTH_SOUTH);
                break;
            }
            case NORTH_SOUTH: {
                BlockPos offset;
                BlockPos blockPos = offset = reversed ? pos.m_122024_() : pos.m_122029_();
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)offset)) {
                    return;
                }
                RailShape otherShape = TrackUtil.getTrackDirection((BlockGetter)level, offset);
                if (otherShape == RailShape.EAST_WEST) break;
                TrackUtil.setRailShape(level, offset, RailShape.EAST_WEST);
                break;
            }
        }
    }

    public static boolean isSwitched(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)SWITCHED);
    }
}

