/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class OneWayTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    private static final double LOSS_FACTOR = 0.49;

    public OneWayTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!OneWayTrackBlock.isPowered(state)) {
            return;
        }
        Vec3 deltaMovement = cart.m_20184_();
        RailShape railShape = OneWayTrackBlock.getRailShapeRaw(state);
        if (RailShapeUtil.isEastWest(railShape)) {
            if (OneWayTrackBlock.isReversed(state) ? deltaMovement.m_7096_() > 0.0 : deltaMovement.m_7096_() < 0.0) {
                double distX = cart.m_20185_() - ((double)pos.m_123341_() + 0.5);
                if (OneWayTrackBlock.isReversed(state) ? distX > 0.01 : distX < -0.01) {
                    cart.m_6034_((double)pos.m_123341_() + 0.5, cart.m_20186_(), cart.m_20189_());
                }
                double deltaX = OneWayTrackBlock.isReversed(state) ? -Math.abs(deltaMovement.m_7096_()) * 0.49 : Math.abs(deltaMovement.m_7096_()) * 0.49;
                cart.m_20334_(deltaX, deltaMovement.m_7098_(), deltaMovement.m_7094_());
            }
        } else if (RailShapeUtil.isNorthSouth(railShape) && (OneWayTrackBlock.isReversed(state) ? deltaMovement.m_7094_() < 0.0 : deltaMovement.m_7094_() > 0.0)) {
            double distZ = cart.m_20189_() - ((double)pos.m_123343_() + 0.5);
            if (OneWayTrackBlock.isReversed(state) ? distZ < -0.01 : distZ > 0.01) {
                cart.m_6034_(cart.m_20185_(), cart.m_20186_(), (double)pos.m_123343_() + 0.5);
            }
            double deltaZ = OneWayTrackBlock.isReversed(state) ? Math.abs(deltaMovement.m_7094_()) * 0.49 : -Math.abs(deltaMovement.m_7094_()) * 0.49;
            cart.m_20334_(deltaMovement.m_7096_(), deltaMovement.m_7098_(), deltaZ);
        }
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.ONE_WAY_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_DIRECTION).m_130940_(ChatFormatting.BLUE));
    }
}

