/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.outfitted.CouplerTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CouplerTrackBlockEntity
extends BlockEntity {
    @Nullable
    private RollingStock pendingCoupling;

    public CouplerTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.COUPLER_TRACK.get(), blockPos, blockState);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode implements StringRepresentable
    {
        COUPLER("coupler", 8){

            @Override
            public void minecartPassed(CouplerTrackBlockEntity track, AbstractMinecart cart) {
                if (CouplerTrackBlock.isPowered(track.m_58900_())) {
                    RollingStock extension = RollingStock.getOrThrow(cart);
                    if (track.pendingCoupling != null) {
                        track.pendingCoupling.link(extension);
                    }
                    track.pendingCoupling = extension;
                }
            }
        }
        ,
        DECOUPLER("decoupler", 0){

            @Override
            public void minecartPassed(CouplerTrackBlockEntity track, AbstractMinecart cart) {
                if (CouplerTrackBlock.isPowered(track.m_58900_())) {
                    RollingStock.getOrThrow(cart).unlinkAll();
                }
            }
        }
        ,
        AUTO_COUPLER("auto_coupler", 0){

            @Override
            public void minecartPassed(CouplerTrackBlockEntity track, AbstractMinecart cart) {
                RollingStock.getOrThrow(cart).setAutoLinkEnabled(CouplerTrackBlock.isPowered(track.m_58900_()));
            }
        };

        private final String name;
        private final int powerPropagation;

        private Mode(String name, int powerPropagation) {
            this.name = name;
            this.powerPropagation = powerPropagation;
        }

        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public Mode previous() {
            return (Mode)EnumUtil.previous((Enum)this, (Enum[])Mode.values());
        }

        public Component getDisplayName() {
            return Component.m_237115_((String)this.getTranslationKey());
        }

        public String getTranslationKey() {
            return Translations.makeKey("tips", "coupler_track." + this.name);
        }

        public String m_7912_() {
            return this.name;
        }

        public int getPowerPropagation() {
            return this.powerPropagation;
        }

        public abstract void minecartPassed(CouplerTrackBlockEntity var1, AbstractMinecart var2);
    }
}

