/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.EnumSet;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.world.level.block.entity.signal.LockableSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ActionSignalBoxBlockEntity
extends LockableSignalBoxBlockEntity {
    private final EnumSet<SignalAspect> actionSignalAspects = EnumSet.of(SignalAspect.GREEN);

    public ActionSignalBoxBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public final EnumSet<SignalAspect> getActionSignalAspects() {
        return this.actionSignalAspects;
    }

    protected final boolean isActionSignalAspect(SignalAspect signalAspect) {
        return this.actionSignalAspects.contains((Object)signalAspect);
    }

    protected final void addActionSignalAspect(SignalAspect signalAspect) {
        this.actionSignalAspects.add(signalAspect);
        this.m_6596_();
    }

    protected final void removeActionSignalAspect(SignalAspect signalAspect) {
        this.actionSignalAspects.remove((Object)signalAspect);
        this.m_6596_();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag actionAspectsTag = new ListTag();
        this.actionSignalAspects.forEach(aspect -> actionAspectsTag.add((Object)StringTag.m_129297_((String)aspect.m_7912_())));
        tag.m_128365_("actionSignalAspects", (Tag)actionAspectsTag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag actionAspectsTag = tag.m_128437_("actionSignalAspects", 8);
        this.actionSignalAspects.clear();
        for (Tag aspectTag : actionAspectsTag) {
            SignalAspect.fromName(aspectTag.m_7916_()).ifPresent(this.actionSignalAspects::add);
        }
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_245616_(this.actionSignalAspects, SignalAspect.class);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.actionSignalAspects.clear();
        this.actionSignalAspects.addAll(data.m_247336_(SignalAspect.class));
    }
}

