/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.util.fluids.AdvancedFluidHandler;
import mods.railcraft.world.inventory.detector.TankDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TankDetectorBlockEntity
extends FilterDetectorBlockEntity {
    private Mode mode = Mode.VOID;

    public TankDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TANK_DETECTOR.get(), blockPos, blockState, 1);
    }

    public FluidStack getFilterFluid() {
        return FluidUtil.getFluidContained((ItemStack)this.m_8020_(0)).orElse(FluidStack.EMPTY);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        for (AbstractMinecart cart : minecarts) {
            LazyOptional fluidHandler = cart.getCapability(ForgeCapabilities.FLUID_HANDLER);
            if (!fluidHandler.resolve().isPresent()) continue;
            AdvancedFluidHandler tank = new AdvancedFluidHandler((IFluidHandler)fluidHandler.resolve().get());
            boolean liquidMatches = false;
            FluidStack filterFluid = this.getFilterFluid();
            FluidStack tankLiquid = tank.drain(1, IFluidHandler.FluidAction.SIMULATE);
            if (filterFluid.isEmpty()) {
                liquidMatches = true;
            } else if (filterFluid.isFluidEqual(tankLiquid)) {
                liquidMatches = true;
            } else if (tank.canPutFluid(new FluidStack(filterFluid, 1))) {
                liquidMatches = true;
            }
            boolean quantityMatches = false;
            switch (this.mode) {
                case VOID: {
                    quantityMatches = true;
                    break;
                }
                case EMPTY: {
                    if (!filterFluid.isEmpty() && tank.isTankEmpty(filterFluid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (!filterFluid.isEmpty() || !tank.areTanksEmpty()) break;
                    quantityMatches = true;
                    break;
                }
                case NOT_EMPTY: {
                    if (!filterFluid.isEmpty() && tank.getFluidQty(filterFluid) > 0) {
                        quantityMatches = true;
                        break;
                    }
                    if (!filterFluid.isEmpty() || !tank.isFluidInTank()) break;
                    quantityMatches = true;
                    break;
                }
                case FULL: {
                    if (!filterFluid.isEmpty() && tank.isTankFull(filterFluid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (!filterFluid.isEmpty() || !tank.areTanksFull()) break;
                    quantityMatches = true;
                    break;
                }
                default: {
                    float level;
                    float f = level = !filterFluid.isEmpty() ? tank.getFluidLevel(filterFluid) : tank.getFluidLevel();
                    if (this.mode == Mode.ANALOG) {
                        return (int)(15.0f * level);
                    }
                    quantityMatches = switch (this.mode) {
                        case Mode.QUARTER -> {
                            if (level >= 0.25f) {
                                yield true;
                            }
                            yield false;
                        }
                        case Mode.HALF -> {
                            if (level >= 0.5f) {
                                yield true;
                            }
                            yield false;
                        }
                        case Mode.MOST -> {
                            if (level >= 0.75f) {
                                yield true;
                            }
                            yield false;
                        }
                        case Mode.LESS_THAN_QUARTER -> {
                            if (level < 0.25f) {
                                yield true;
                            }
                            yield false;
                        }
                        case Mode.LESS_THAN_HALF -> {
                            if (level < 0.5f) {
                                yield true;
                            }
                            yield false;
                        }
                        case Mode.LESS_THAN_MOST -> {
                            if (level < 0.75f) {
                                yield true;
                            }
                            yield false;
                        }
                        case Mode.LESS_THAN_FULL -> {
                            if (level < 1.0f) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> false;
                    };
                }
            }
            return liquidMatches && quantityMatches ? 15 : 0;
        }
        return 0;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("mode", this.mode.m_7912_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mode = Mode.fromName(tag.m_128461_("mode"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_130068_((Enum)this.mode);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.mode = (Mode)data.m_130066_(Mode.class);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TankDetectorMenu(id, inventory, this);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Mode implements ButtonState<Mode>,
    StringRepresentable
    {
        VOID("void", "L = *"),
        EMPTY("empty", "L = 0%"),
        NOT_EMPTY("not_empty", "L > 0%"),
        FULL("full", "L = 100%"),
        QUARTER("quarter", "L >= 25%"),
        HALF("half", "L >= 50%"),
        MOST("most", "L >= 75%"),
        LESS_THAN_QUARTER("less_than_quarter", "L < 25%"),
        LESS_THAN_HALF("less_than_half", "L < 50%"),
        LESS_THAN_MOST("less_than_most", "L < 75%"),
        LESS_THAN_FULL("less_than_full", "L < 100%"),
        ANALOG("analog", "L = ~");

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String name;
        private final String label;

        private Mode(String name, String label) {
            this.name = name;
            this.label = label;
        }

        @Override
        public Component label() {
            return Component.m_237113_((String)this.label);
        }

        @Override
        public TexturePosition texturePosition() {
            return ButtonTexture.LARGE_BUTTON;
        }

        @Override
        public Optional<Component> tooltip() {
            return Optional.of(Component.m_237115_((String)Translations.makeKey("screen", "tank_detector." + this.name)));
        }

        @Override
        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public String m_7912_() {
            return this.name;
        }

        public static Mode fromName(String name) {
            return (Mode)CODEC.m_262792_(name, (Enum)VOID);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Mode::values);
        }
    }
}

