/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ForwardingContainer;
import mods.railcraft.util.container.ItemHandlerFactory;
import mods.railcraft.world.level.block.entity.detector.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public abstract class FilterDetectorBlockEntity
extends DetectorBlockEntity
implements MenuProvider,
ForwardingContainer,
ContainerManipulator<ModifiableSlotAccessor> {
    private final AdvancedContainer invFilters;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    private Map<Direction, LazyOptional<IItemHandler>> directionalItemHandlers = new EnumMap<Direction, LazyOptional<IItemHandler>>(Direction.class);

    protected FilterDetectorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize) {
        super(type, blockPos, blockState);
        this.invFilters = new AdvancedContainer(inventorySize).listener(this).phantom();
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.invFilters.stream();
    }

    @Override
    public boolean m_6542_(Player player) {
        return this.isStillValid(player);
    }

    @Override
    public Container container() {
        return this.invFilters;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return direction == null ? this.itemHandler.cast() : this.directionalItemHandlers.computeIfAbsent(direction, __ -> LazyOptional.of(() -> ItemHandlerFactory.wrap(this, direction))).cast();
        }
        return super.getCapability(capability, direction);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.invFilters.m_7797_(tag.m_128437_("container", 10));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("container", (Tag)this.invFilters.m_7927_());
    }
}

