/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import mods.railcraft.api.core.BlockEntityLike;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.api.core.Ownable;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.world.module.BlockModuleProvider;
import mods.railcraft.world.module.Module;
import mods.railcraft.world.module.ModuleDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftBlockEntity
extends BlockEntity
implements NetworkSerializable,
Ownable,
BlockEntityLike,
BlockModuleProvider {
    protected final ModuleDispatcher moduleDispatcher = new ModuleDispatcher();
    @Nullable
    private GameProfile owner;
    @Nullable
    private Component customName;

    public RailcraftBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public final CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        this.writeToBuf(packetBuffer);
        byte[] syncData = new byte[packetBuffer.readableBytes()];
        packetBuffer.readBytes(syncData);
        nbt.m_128382_("sync", syncData);
        return nbt;
    }

    public final void handleUpdateTag(CompoundTag tag) {
        byte[] bytes = tag.m_128463_("sync");
        this.readFromBuf(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes)));
    }

    public final void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        this.handleUpdateTag(packet.m_131708_());
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        out.m_236821_((Object)this.owner, FriendlyByteBuf::m_236803_);
        out.m_236821_((Object)this.customName, FriendlyByteBuf::m_130083_);
        this.moduleDispatcher.writeToBuf(out);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        this.owner = (GameProfile)in.m_236868_(FriendlyByteBuf::m_236875_);
        this.customName = (Component)in.m_236868_(FriendlyByteBuf::m_130238_);
        this.moduleDispatcher.readFromBuf(in);
    }

    @Override
    public BlockPos blockPos() {
        return this.m_58899_();
    }

    @Override
    public Level level() {
        return this.m_58904_();
    }

    @Override
    public void syncToClient() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
            NetworkChannel.sendToTrackingChunk(packet, serverLevel, this.m_58899_());
        }
    }

    @Override
    public void save() {
        this.m_6596_();
    }

    @Override
    public <T extends Module> Optional<T> getModule(Class<T> type) {
        return this.moduleDispatcher.getModule(type);
    }

    @Override
    public boolean isStillValid(Player player) {
        return RailcraftBlockEntity.isStillValid(this, player, 64);
    }

    @Override
    public final void setOwner(@Nullable GameProfile profile) {
        this.owner = profile;
    }

    @Override
    @NotNull
    public final Optional<GameProfile> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public final boolean isOwner(@NotNull GameProfile gameProfile) {
        return gameProfile.equals((Object)this.owner);
    }

    public final boolean isOwnerOrOperator(@NotNull GameProfile gameProfile) {
        return this.isOwner(gameProfile) || !this.f_58857_.m_5776_() && ((ServerLevel)this.f_58857_).m_7654_().m_6846_().m_11303_(gameProfile);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            CompoundTag ownerTag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)ownerTag, (GameProfile)this.owner);
            tag.m_128365_("owner", (Tag)ownerTag);
        }
        if (this.customName != null) {
            tag.m_128359_("customName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128365_("modules", (Tag)this.moduleDispatcher.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("owner", 10)) {
            this.owner = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("owner"));
        }
        if (tag.m_128425_("customName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("customName"));
        }
        this.moduleDispatcher.deserializeNBT(tag.m_128469_("modules"));
    }

    public final int getX() {
        return this.m_58899_().m_123341_();
    }

    public final int getY() {
        return this.m_58899_().m_123342_();
    }

    public final int getZ() {
        return this.m_58899_().m_123343_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    protected void setCustomName(@Nullable Component name) {
        this.customName = name;
        this.syncToClient();
    }

    public Component m_7755_() {
        return this.m_8077_() ? this.customName : this.m_58900_().m_60734_().m_49954_();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Override
    public final BlockEntity asBlockEntity() {
        return this;
    }

    public static boolean isStillValid(BlockEntity blockEntity, Player player, int maxDistance) {
        BlockPos pos = blockEntity.m_58899_();
        double distance = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return !blockEntity.m_58901_() && blockEntity.m_58904_().m_7702_(pos).equals(blockEntity) && distance <= (double)maxDistance;
    }
}

