/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class CartDisassemblyRecipe
extends CustomRecipe {
    private final Item ingredient;
    private final Item result;

    public CartDisassemblyRecipe(ResourceLocation id, Item ingredient, Item result, CraftingBookCategory category) {
        super(id, category);
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean matches(CraftingContainer container, Level level) {
        long items = IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)container).m_8020_(arg_0)).filter(x -> !x.m_41619_()).count();
        return items == 1L && container.m_216874_(x -> x.m_150930_(this.ingredient));
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 1 && height >= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)this.result);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.ingredient}));
        return ingredients;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList grid = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_150930_(this.ingredient)) continue;
            grid.set(i, (Object)new ItemStack((ItemLike)Items.f_42449_));
        }
        return grid;
    }
}

