/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import mods.railcraft.api.item.MinecartFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;

public class CartItem
extends Item {
    private final MinecartFactory minecartFactory;

    public CartItem(MinecartFactory minecartFactory, Item.Properties properties) {
        super(properties);
        this.minecartFactory = minecartFactory;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos railPos;
        Level level = context.m_43725_();
        if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)(railPos = context.m_8083_()))) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Player player = context.m_43723_();
            BlockState railState = level.m_8055_(railPos);
            ItemStack itemStack = player.m_21120_(context.m_43724_());
            RailShape railShape = RailShape.NORTH_SOUTH;
            Block block = railState.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                railShape = baseRailBlock.getRailDirection(railState, (BlockGetter)level, railPos, null);
            }
            double d0 = railShape.m_61745_() ? 0.5 : 0.0;
            AbstractMinecart minecart = this.minecartFactory.createMinecart(itemStack, (double)railPos.m_123341_() + 0.5, (double)railPos.m_123342_() + d0 + 0.0625, (double)railPos.m_123343_() + 0.5, serverLevel);
            if (minecart != null) {
                minecart.m_146922_(context.m_8125_().m_122435_());
                level.m_7967_((Entity)minecart);
                level.m_220407_(GameEvent.f_157810_, railPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)level.m_8055_(railPos.m_7495_())));
                itemStack.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public MinecartFactory getMinecartFactory() {
        return this.minecartFactory;
    }
}

