/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.TrackLayerMenu;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;

public class TrackLayer
extends MaintenancePatternMinecart {
    private static final int SLOT_STOCK = 0;
    private static final int SLOT_REPLACE = 0;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);

    public TrackLayer(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackLayer(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TRACK_LAYER.get(), x, y, z, (Level)level);
    }

    @Override
    public Item m_213728_() {
        return (Item)RailcraftItems.TRACK_LAYER.get();
    }

    protected void m_6401_(BlockPos pos, BlockState state) {
        super.m_6401_(pos, state);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.stockItems(0, 0);
        this.updateTravelDirection(pos, state);
        this.travelDirection().ifPresent(direction -> this.placeTrack(pos, (Direction)direction));
    }

    private void placeTrack(BlockPos pos, Direction direction) {
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        pos = pos.m_121945_(direction);
        RailShape railShape = RailShape.NORTH_SOUTH;
        if (direction == Direction.EAST || direction == Direction.WEST) {
            railShape = RailShape.EAST_WEST;
        }
        if (!this.isValidReplacementBlock(pos) && this.isValidReplacementBlock(pos.m_7494_()) && !RailShapeUtil.isTurn(railShape)) {
            pos = pos.m_7494_();
        }
        if (this.isValidReplacementBlock(pos) && this.isValidReplacementBlock(pos.m_7495_())) {
            pos = pos.m_7495_();
            railShape = switch (direction) {
                case Direction.NORTH -> RailShape.ASCENDING_SOUTH;
                case Direction.SOUTH -> RailShape.ASCENDING_NORTH;
                case Direction.WEST -> RailShape.ASCENDING_WEST;
                case Direction.EAST -> RailShape.ASCENDING_EAST;
                default -> throw new IllegalArgumentException("Unexpected value: " + direction);
            };
        }
        if (this.isValidNewTrackPosition(pos)) {
            BlockState targetState = this.m_9236_().m_8055_(pos);
            if (this.placeNewTrack(pos, 0, railShape)) {
                Block.m_49950_((BlockState)targetState, (Level)this.m_9236_(), (BlockPos)pos);
            }
        }
    }

    private boolean isValidNewTrackPosition(BlockPos pos) {
        return this.isValidReplacementBlock(pos) && Block.m_49936_((BlockGetter)this.m_9236_(), (BlockPos)pos.m_7495_());
    }

    private boolean isValidReplacementBlock(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        return state.m_60795_() || block instanceof IPlantable || block instanceof IForgeShearable || state.m_204336_(RailcraftTags.Blocks.TUNNEL_BORE_REPLACEABLE_BLOCKS);
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternContainer.m_8020_(0);
        return ItemStack.m_41656_((ItemStack)stack, (ItemStack)trackReplace);
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory inventory) {
        return new TrackLayerMenu(id, inventory, this);
    }
}

